/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.codeinsights;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.codeinsights.CodeInsightsOverviewReport;
import com.atlassian.webdriver.bitbucket.page.PullRequestEffectiveDiffPage;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CodeInsightsOverviewAnnotation
extends AbstractElementPageObject {
    private final CodeInsightsOverviewReport parent;

    public CodeInsightsOverviewAnnotation(@Nonnull PageElement container, CodeInsightsOverviewReport parent) {
        super(container);
        this.parent = parent;
    }

    public String getDeepLinkUrl() {
        return this.getDeepLink().getText();
    }

    public String getDeepLinkHref() {
        return this.getDeepLink().getAttribute("href");
    }

    public String getFileName() {
        return this.find(By.className((String)"file-name")).getText();
    }

    public Optional<Integer> getLineNumber() {
        Iterator<PageElement> lineNumberElement = this.findAll(By.className((String)"line-number")).iterator();
        if (!lineNumberElement.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(Integer.valueOf(lineNumberElement.next().getText()));
    }

    public String getMessage() {
        return this.find(By.className((String)"message-column")).find(By.tagName((String)"span")).getText();
    }

    public AnnotationSeverity getSeverity() {
        return AnnotationSeverity.valueOf((String)this.find(By.className((String)"severity-column")).find(By.tagName((String)"span")).getCssClasses().stream().map(className -> className.replace("severity-", "")).findFirst().get());
    }

    public boolean hasDeepLinkUrl() {
        return !this.find(By.className((String)"file-column")).findAll(By.tagName((String)"a")).isEmpty();
    }

    public PullRequestEffectiveDiffPage navigate() {
        String fileName = this.getFileName();
        Optional<Integer> lineNumber = this.getLineNumber();
        this.getDeepLink().click();
        return (PullRequestEffectiveDiffPage)this.pageBinder.bind(PullRequestEffectiveDiffPage.class, new Object[]{this.parent.getProjectKey(), this.parent.getSlug(), this.parent.getPullRequestId(), fileName, lineNumber.orElse(null)});
    }

    private PageElement getDeepLink() {
        return this.find(By.className((String)"file-column")).find(By.tagName((String)"a"));
    }
}

