/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.PullRequestMergeDiagram;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class PullRequestMergeConfirmDialog<T extends PullRequestPage>
extends Dialog2 {
    private final T page;
    @ElementBy(id="pull-request-cleanup-checkbox-label")
    private PageElement cleanupPullRequestLabel;
    @ElementBy(id="pull-request-cleanup-checkbox")
    private PageElement cleanupPullrequestCheckbox;
    @ElementBy(cssSelector=".CodeMirror")
    private PageElement codeMirrorCommitMessage;
    @ElementBy(className="confirm-button")
    private PageElement mergeButton;
    @ElementBy(cssSelector=".branch-diagram")
    private PageElement mergeDiagram;
    @ElementBy(id="merge-strategy-button")
    private PageElement mergeStrategyDropDown;

    public PullRequestMergeConfirmDialog(By locatable, TimeoutType timeoutType, T page) {
        super(locatable, timeoutType);
        this.page = page;
    }

    public T confirmAndWaitForReload() {
        ((AbstractPage)this.page).waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                PullRequestMergeConfirmDialog.this.mainActionButton.click();
            }
        });
        return this.page;
    }

    public T confirmMerge() {
        this.clickMainAction();
        return this.page;
    }

    public T confirmMergeExpectingWarning(By warningDialogLocator) {
        this.clickMainActionExpectingAnotherDialog();
        Dialog2 warningDialog = (Dialog2)((Object)this.pageBinder.bind(Dialog2.class, new Object[]{warningDialogLocator}));
        Poller.waitUntilTrue((TimedQuery)warningDialog.find(By.className((String)"aui-message-warning")).timed().isVisible());
        warningDialog.find(By.className((String)"close-button")).click();
        return this.page;
    }

    public PageElement getCleanupPullrequestCheckbox() {
        return this.cleanupPullrequestCheckbox;
    }

    public PageElement getCleanupPullrequestLabel() {
        return this.cleanupPullRequestLabel;
    }

    public PageElement getMergeButton() {
        return this.mergeButton;
    }

    public PullRequestMergeDiagram getMergeDiagram() {
        return (PullRequestMergeDiagram)this.pageBinder.bind(PullRequestMergeDiagram.class, new Object[]{this.mergeDiagram});
    }

    public PageElement getMergeStrategyDropDown() {
        return this.mergeStrategyDropDown;
    }

    public PullRequestMergeConfirmDialog<T> setCommitMessage(String msg) {
        this.codeMirrorCommitMessage.javascript().execute("arguments[0].CodeMirror.setValue('" + msg.replace("\n", "\\n").replace("\t", "\\t").replace("'", "\\'") + "');", new Object[0]);
        Poller.waitUntil((TimedQuery)this.codeMirrorCommitMessage.timed().getText(), (Matcher)CoreMatchers.equalTo((Object)msg));
        return this;
    }
}

