/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;

public class LikesInfoDialog {
    @Inject
    private PageElementFinder elementFinder;
    private PageElement dialog;

    @Init
    public void init() {
        this.dialog = this.elementFinder.find(By.className((String)"comment-likes-dialog"));
    }

    public int getNumberOfUsers() {
        return this.getUsers().size();
    }

    public String getUserName(int index) {
        return this.getUsers().get(index).getText();
    }

    private List<PageElement> getUsers() {
        return this.dialog.find(By.className((String)"user-list")).findAll(By.tagName((String)"li"));
    }

    public TimedCondition isOpen() {
        TimedCondition positionOnScreen = Conditions.forMatcher((TimedQuery)this.dialog.timed().getLocation(), (Matcher)new BaseMatcher<Point>(){

            public void describeTo(Description description) {
                description.appendText("Point must have both x and y greater than 0");
            }

            public boolean matches(Object item) {
                if (item instanceof Point) {
                    Point point = (Point)item;
                    return point.getY() > 0 && point.getX() > 0;
                }
                return false;
            }
        });
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.dialog.timed().isVisible(), positionOnScreen});
    }
}

