/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DashboardPullRequestSection
extends AbstractElementPageObject {
    public DashboardPullRequestSection(@Nonnull PageElement container) {
        super(container);
    }

    @WaitUntil
    public void waitForLoad() {
        Poller.waitUntilTrue((TimedQuery)this.container.find(By.className((String)"more-container")).timed().isPresent());
    }

    public void clickLoadMore() {
        final int initialSize = this.getPullRequests().size();
        ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)".more-container button")));
        this.container.find(By.cssSelector((String)".more-container button")).click();
        Poller.waitUntilTrue((String)"The number of PRs has grown", (TimedQuery)new AbstractTimedCondition(5000L, 100L){

            protected Boolean currentValue() {
                return DashboardPullRequestSection.this.getPullRequests().size() > initialSize;
            }
        });
    }

    public List<PullRequestRow> getPullRequests() {
        return this.container.findAll(By.cssSelector((String)"tbody tr")).stream().map(ElementUtils.bind(this.pageBinder, PullRequestRow.class, new Object[0])).collect(Collectors.toList());
    }

    public TimedCondition isEmpty() {
        return this.container.find(By.className((String)"pull-request-list-empty-state")).timed().isVisible();
    }

    public static class PullRequestRow
    extends AbstractElementPageObject {
        public PullRequestRow(@Nonnull PageElement container) {
            super(container);
        }

        public Optional<String> getBadge() {
            PageElement pageElement = this.container.find(By.className((String)"aui-lozenge"));
            if (!pageElement.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(pageElement.getText());
        }

        public String getTitle() {
            return this.container.find(By.cssSelector((String)".title a")).getText();
        }
    }
}

