/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.util;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtils {
    public static String removeQueryString(String url) {
        int pos = url.lastIndexOf(63);
        return pos > 0 ? url.substring(0, pos) : url;
    }

    public static String uriEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static Map<String, String> getQueryParams(String url) {
        String[] params = URI.create(url).getQuery().split("&");
        HashMap map = Maps.newHashMap();
        for (String param : params) {
            String[] split = param.split("=");
            try {
                map.put(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    public static String getReferenceNameFromUrlParameter(String param, String URL2) {
        Pattern pattern;
        Matcher matcher;
        URI uri;
        String regex = param + "=(?:refs/heads/)*([^&\\s]+)";
        try {
            uri = new URI(URL2);
        }
        catch (URISyntaxException e) {
            return "";
        }
        String queryParams = uri.getQuery();
        if (queryParams != null && (matcher = (pattern = Pattern.compile(regex)).matcher(queryParams)).find()) {
            return matcher.group(1);
        }
        return "";
    }
}

