/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import org.openqa.selenium.By;

public class AbstractBranchModelRepositorySettingsPage
extends AbstractBranchModelSettingsPage {
    private final String projectKey;
    private final String slug;

    public AbstractBranchModelRepositorySettingsPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public TimedElement getConfirmationDialog() {
        return this.getPageElementById("are-you-sure-dialog").timed();
    }

    @Override
    public AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration)this.pageBinder.bind(RepositoryDevelopmentBranchConfiguration.class, new Object[0]);
    }

    public PageElement getPageElementByCSS(String cssSelector) {
        return this.elementFinder.find(By.cssSelector((String)cssSelector));
    }

    public PageElement getPageElementById(String id) {
        return this.elementFinder.find(By.id((String)id));
    }

    @Override
    public RepositoryProductionBranchConfiguration getProductionConfiguration() {
        return (RepositoryProductionBranchConfiguration)this.pageBinder.bind(RepositoryProductionBranchConfiguration.class, new Object[0]);
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.projectKey + "/repos/" + this.slug;
    }

    @Override
    AbstractBranchModelRepositorySettingsPage rebind() {
        return (AbstractBranchModelRepositorySettingsPage)this.pageBinder.bind(AbstractBranchModelRepositorySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public static class RepositoryProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration {
        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration clearBranchNameField() {
            this.getBranchNameSelector().clearInput();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameField().getSelectedValue();
        }

        private SearchableSelector getBranchNameField() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        private SearchableSelector getBranchNameSelector() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration typeBranchName(String name) {
            SearchableSelector selector = this.getBranchNameSelector();
            if (!((Boolean)selector.getDialog().isOpen().byDefaultTimeout()).booleanValue()) {
                selector.open();
            }
            selector.getDialog().filterBy(name).selectItemByName(name);
            return this;
        }
    }

    public static class RepositoryDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration {
        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration clearBranchNameField() {
            this.getBranchNameSelector().clearInput();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            return this.getBranchNameSelector().getSelectedValue();
        }

        private SearchableSelector getBranchNameSelector() {
            return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.finder.find(By.id((String)("branch-model-" + this.type))), By.id((String)("branch-model-" + this.type + "-dialog")), this.finder.find(By.id((String)("branch-model-" + this.type + "-field")))});
        }

        @Override
        public AbstractBranchModelSettingsPage.AbstractBranchConfiguration typeBranchName(String name) {
            SearchableSelector selector = this.getBranchNameSelector();
            if (!((Boolean)selector.getDialog().isOpen().byDefaultTimeout()).booleanValue()) {
                selector.open();
            }
            selector.getDialog().filterBy(name).selectItemByName(name);
            return this;
        }
    }
}

