/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.UserDeleteDialog;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserAddPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserEditPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class UserListPage
extends BitbucketPage {
    @ElementBy(className="create-user-link")
    private PageElement addUserButton;
    @ElementBy(id="list-users")
    private PageElement userList;
    @ElementBy(className="paged-table-filter-input")
    private PageElement filterTextbox;
    @ElementBy(cssSelector=".aui-message-success")
    private PageElement successMessage;

    public String getUrl() {
        return "/admin/users";
    }

    public UserAddPage clickAdd() {
        this.addUserButton.click();
        return (UserAddPage)this.pageBinder.bind(UserAddPage.class, new Object[0]);
    }

    public UserRow getUser(String name) {
        for (PageElement row : this.userList.findAll(Locators.tableRow())) {
            UserRow userRow = new UserRow(row);
            if (!name.equals(userRow.getName())) continue;
            return userRow;
        }
        return null;
    }

    public List<UserRow> getUsers() {
        List tableRows = this.userList.findAll(Locators.tableRow());
        ArrayList<UserRow> users = new ArrayList<UserRow>(tableRows.size());
        for (PageElement row : tableRows) {
            users.add(new UserRow(row));
        }
        return users;
    }

    public String getDeleteSuccessMessage() {
        return ((String)Poller.waitUntil((TimedQuery)this.successMessage.timed().getText(), (Matcher)Matchers.containsString((String)"delete"))).trim();
    }

    public UserListPage setFilter(final String filter) {
        ElementUtils.waitUntilUpdated(this.userList, new Runnable(){

            @Override
            public void run() {
                UserListPage.this.filterTextbox.clear().type(new CharSequence[]{filter});
            }
        });
        return (UserListPage)this.pageBinder.bind(UserListPage.class, new Object[0]);
    }

    public class UserRow {
        private final PageElement row;

        public UserRow(PageElement row) {
            this.row = row;
        }

        public String getName() {
            return this.getColumnText("username");
        }

        public String getFullname() {
            return this.getColumnText("fullname");
        }

        public String getEmail() {
            return this.getColumnText("email");
        }

        private String getColumnText(String section) {
            PageElement column = this.getColumn(section);
            return column.isPresent() ? column.getText() : null;
        }

        private PageElement getColumn(String section) {
            return this.row.find(By.cssSelector((String)("td[headers='" + section + "']")));
        }

        public UserEditPage clickView() {
            this.getColumn("fullname").find(By.tagName((String)"a")).click();
            return (UserEditPage)UserListPage.this.pageBinder.bind(UserEditPage.class, new Object[0]);
        }

        public UserDeleteDialog clickDelete() {
            ElementUtils.displayAllDeleteButtons(UserListPage.this.javascriptExecutor);
            PageElement deleteUser = this.getColumn("actions").find(By.className((String)"delete-user"));
            ElementUtils.scrollIntoViewIfNeeded(deleteUser);
            deleteUser.javascript().execute("arguments[0].focus()", new Object[0]);
            deleteUser.click();
            UserDeleteDialog dialog = (UserDeleteDialog)UserListPage.this.body.find(By.id((String)"delete-dialog"), UserDeleteDialog.class);
            Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
            return dialog;
        }
    }
}

