/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.webdriver.bitbucket.element.PermissionRow;
import com.atlassian.webdriver.bitbucket.element.PermissionTable;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.PermissionsPage;

public class GlobalPermissionsPage
extends BitbucketPage
implements PermissionsPage {
    @ElementBy(id="user-permissions-table")
    private PermissionTable userPermissionsTable;
    @ElementBy(id="group-permissions-table")
    private PermissionTable groupPermissionsTable;

    public String getUrl() {
        return "/admin/permissions";
    }

    @Override
    public void doWait() {
        super.doWait();
        this.userPermissionsTable.waitUntilLoaded();
        this.groupPermissionsTable.waitUntilLoaded();
    }

    private PermissionTable getPermissionTable(PermissionsPage.PermissionEntityType entityType) {
        return entityType == PermissionsPage.PermissionEntityType.GROUP ? this.groupPermissionsTable : this.userPermissionsTable;
    }

    public void removeItem(PermissionsPage.PermissionEntityType entityType, String objectId) {
        this.getPermissionTable(entityType).removeItem(objectId);
    }

    public void removeUser(String username) {
        this.userPermissionsTable.removeItem(username);
    }

    public void removeGroup(String name) {
        this.groupPermissionsTable.removeItem(name);
    }

    public PermissionRow removeItemAndExpectError(PermissionsPage.PermissionEntityType entityType, String objectId) {
        return this.getPermissionTable(entityType).removeItemAndExpectError(objectId);
    }

    public PermissionRow removeUserAndExpectError(String username) {
        return this.userPermissionsTable.removeItemAndExpectError(username);
    }

    public PermissionRow removeGroupAndExpectError(String name) {
        return this.groupPermissionsTable.removeItemAndExpectError(name);
    }

    public PermissionRow getRow(PermissionsPage.PermissionEntityType entityType, String objectId) {
        return this.getPermissionTable(entityType).getRow(objectId);
    }

    public boolean rowIsVisible(PermissionsPage.PermissionEntityType entityType, String objectId) {
        return this.getPermissionTable(entityType).rowIsPresent(objectId);
    }

    public GlobalPermissionsPage showAllRemoveButtons() {
        this.userPermissionsTable.showAllRemoveButtons();
        this.groupPermissionsTable.showAllRemoveButtons();
        return this;
    }

    public void loadMore(PermissionsPage.PermissionEntityType entityType) {
        PermissionTable permissionTable = this.getPermissionTable(entityType);
        permissionTable.getLoadMoreLink().click();
        permissionTable.waitUntilLoaded();
    }

    public PermissionRow getUserItem(String username) {
        return this.userPermissionsTable.getRow(username);
    }

    public PermissionRow getGroupItem(String group) {
        return this.groupPermissionsTable.getRow(group);
    }

    @Override
    public PermissionTable getPermissionsTable(PermissionsPage.PermissionEntityType entityType) {
        switch (entityType) {
            case USER: {
                return this.userPermissionsTable;
            }
            case GROUP: {
                return this.groupPermissionsTable;
            }
        }
        throw new UnsupportedOperationException();
    }
}

