/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverCheckboxElement;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryEditSettingsPage;

public class PullRequestRepositorySettingsPage
extends BaseRepositoryPage {
    @ElementBy(id="requiredApprovers")
    private WebDriverCheckboxElement requiredApprovers;
    @ElementBy(id="requiredApproversCount")
    private PageElement requiredApproversCount;
    @ElementBy(id="requirePullRequestTasksResolved")
    private WebDriverCheckboxElement requireTasksCompletedCheckbox;
    @ElementBy(id="require-all-approvers-for-merge")
    private WebDriverCheckboxElement requireAllApprovalsCheckbox;
    @ElementBy(cssSelector="form.pull-request-settings #submit")
    private PageElement saveButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;

    public PullRequestRepositorySettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/pull-requests", this.projectKey, this.slug);
    }

    public PullRequestRepositorySettingsPage clickSave() {
        this.scrollToBottom();
        this.waitForPageLoad(() -> ((PageElement)this.saveButton).click());
        return (PullRequestRepositorySettingsPage)this.pageBinder.bind(PullRequestRepositorySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage clickCancel() {
        this.waitForPageLoad(() -> ((PageElement)this.cancelLink).click());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }
}

