/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseProjectPage;
import com.atlassian.webdriver.bitbucket.page.ProjectDeleteConfirmationPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ProjectEditSettingsPage
extends BaseProjectPage {
    @ElementBy(name="name")
    private PageElement nameField;
    @ElementBy(name="key")
    private PageElement keyField;
    @ElementBy(name="description")
    private PageElement descriptionField;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(id="projects-settings-delete-button")
    private PageElement deleteButton;

    public ProjectEditSettingsPage(String key) {
        super(key);
    }

    public String getUrl() {
        return String.format("/projects/%s/settings", this.getProjectKey());
    }

    public ProjectEditSettingsPage setName(String name) {
        this.nameField.clear();
        this.nameField.type(new CharSequence[]{name});
        return this;
    }

    public ProjectEditSettingsPage setKey(String key) {
        this.keyField.clear();
        this.keyField.type(new CharSequence[]{key});
        return this;
    }

    public ProjectEditSettingsPage setDescription(String description) {
        this.descriptionField.clear();
        this.descriptionField.type(new CharSequence[]{description});
        return this;
    }

    public String getNameValue() {
        return this.nameField.getValue();
    }

    public String getKeyValue() {
        return this.keyField.getValue();
    }

    public String getDescriptionValue() {
        return this.descriptionField.getValue();
    }

    public ProjectEditSettingsPage submitSuccess() {
        String key = this.keyField.getValue();
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                ProjectEditSettingsPage.this.submitButton.click();
            }
        });
        return (ProjectEditSettingsPage)this.pageBinder.bind(ProjectEditSettingsPage.class, new Object[]{key});
    }

    public ProjectEditSettingsPage submitFail() {
        this.submitButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#submit:enabled")).timed().isPresent());
        return (ProjectEditSettingsPage)this.pageBinder.bind(ProjectEditSettingsPage.class, new Object[]{this.getProjectKey()});
    }

    public boolean isDeleteShowing() {
        return this.deleteButton.isPresent();
    }

    public ProjectDeleteConfirmationPage clickDelete() {
        this.deleteButton.click();
        return (ProjectDeleteConfirmationPage)this.pageBinder.bind(ProjectDeleteConfirmationPage.class, new Object[]{this.getProjectKey()});
    }

    public boolean wasAccessDenied() {
        try {
            return this.driver.findElements(By.cssSelector((String)".bitbucket-errors ._401")).size() > 0;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public String getFieldError(String fieldName) {
        try {
            WebElement element = this.driver.findElement(By.cssSelector((String)String.format("div.field-group > input#%s ~ div.error", fieldName)));
            return element.getText().trim();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getKeyError() {
        return this.getFieldError("key");
    }
}

