/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openqa.selenium.By;

public abstract class BaseMergeStrategiesSettingsPage
extends BaseSidebarPage {
    @ElementBy(id="merge-strategies-cancel")
    protected PageElement cancelLink;
    @ElementBy(id="merge-strategies")
    protected PageElement mergeConfig;
    @ElementBy(id="merge-strategies-submit")
    protected PageElement saveButton;

    public void clickCancel() {
        this.scrollToBottom();
        this.cancelLink.click();
    }

    public void clickSave() {
        this.scrollToBottom();
        this.saveButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-flag")).timed().isVisible());
    }

    public void disableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.name((String)"enabledIds")).stream().filter(element -> {
            String checked = element.getAttribute("checked");
            return checked != null && strategyIds.contains(element.getId());
        }).forEach(PageElement::click);
    }

    public void enableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.name((String)"enabledIds")).stream().filter(element -> {
            String checked = element.getAttribute("checked");
            return checked == null && strategyIds.contains(element.getId());
        }).forEach(PageElement::click);
    }

    public String getDefaultMergeStrategy() {
        return this.mergeConfig.find(By.cssSelector((String)".default-merge-strategy input:checked")).getValue();
    }

    public List<String> getEnabledMergeStrategies() {
        return (List)this.mergeConfig.findAll(By.cssSelector((String)".merge-strategy input[checked]")).stream().map(PageElement::getValue).collect(MoreCollectors.toImmutableList());
    }

    public List<String> getStrategiesWithSetAsDefaultLink() {
        return (List)this.mergeConfig.findAll(By.cssSelector((String)".default-merge-strategy :not([checked]):not([disabled])")).stream().map(PageElement::getValue).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
    }

    public void setDefaultMergeStrategy(String defaultId) {
        this.mergeConfig.find(By.cssSelector((String)("input[name=\"defaultId\"][value=\"" + defaultId + "\"]"))).click();
    }
}

