/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.hooks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookRow;
import com.atlassian.webdriver.bitbucket.page.admin.hooks.RepositoryHooksPage;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryHookToggleRow
extends RepositoryHookRow {
    public RepositoryHookToggleRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage parent) {
        super(row, parent);
    }

    @Override
    public RepositoryHookRow bind() {
        return (RepositoryHookRow)this.pageBinder.bind(RepositoryHookToggleRow.class, new Object[]{this.container, this.parent});
    }

    @Override
    public TimedQuery<RepositoryHookRow.HookState> getState() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            if (this.getToggle().getAttribute("checked") == null) {
                return RepositoryHookRow.HookState.DISABLED;
            }
            return RepositoryHookRow.HookState.ENABLED;
        });
    }

    @Override
    protected void selectState(RepositoryHookRow.HookState hookState) {
        if (this.getState().byDefaultTimeout() != hookState) {
            this.getToggle().select();
        }
    }

    private PageElement getToggle() {
        return this.container.find(By.cssSelector((String)".hook-toggle-cell aui-toggle"));
    }
}

