/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class PullRequestMergeDiagram
extends AbstractElementPageObject {
    public PullRequestMergeDiagram(@Nonnull PageElement container) {
        super(container);
    }

    @WaitUntil
    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.find(By.cssSelector((String)".source-ref")).timed().isVisible());
    }

    public Boolean isAutoMerge() {
        return this.container.hasClass("branch-diagram-automerge");
    }

    public String getSourceRef() {
        return this.getRef(this.find(By.cssSelector((String)".source-ref")));
    }

    public String getTargetRef() {
        return this.getRef(this.find(By.cssSelector((String)".target-ref")));
    }

    public List<String> getAutomergePath() {
        if (!this.isAutoMerge().booleanValue()) {
            return Collections.emptyList();
        }
        Iterable<PageElement> elems = this.findAll(By.cssSelector((String)".automerge-path .ref-lozenge"));
        return MoreStreams.streamIterable(elems).map(this::getRef).collect(Collectors.toList());
    }

    private String getRef(PageElement elem) {
        return elem.getAttribute("data-ref-tooltip");
    }
}

