/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.CommentForm;
import com.google.common.collect.Iterables;
import java.util.List;
import org.openqa.selenium.By;

public class DiffCommentForm
extends CommentForm {
    public DiffCommentForm(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    protected List<Comment> getDiffComments() {
        return this.elementFinder.findAll(By.cssSelector((String)".comment-container .comment"), Comment.class);
    }

    protected List<Long> getDiffCommentIds() {
        return DiffCommentForm.toIdList(this.getDiffComments());
    }

    @Override
    public Comment submit() {
        List<Comment> oldComments = this.getDiffComments();
        this.getCommentButton().click();
        Poller.waitUntilTrue((TimedQuery)this.commentAdded(oldComments));
        return this.getNewComment(oldComments);
    }

    protected TimedCondition commentAdded(List<Comment> oldComments) {
        List<Long> oldIds = DiffCommentForm.toIdList(oldComments);
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> this.getDiffComments().size() > oldIds.size());
    }

    private Comment getNewComment(List<Comment> oldComments) {
        List<Long> oldIds = DiffCommentForm.toIdList(oldComments);
        return (Comment)((Object)Iterables.find(this.getDiffComments(), comment -> !oldIds.contains(comment.getCommentId()), null));
    }
}

