/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;

public class DateUtils {
    public static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public static Date parse(DateFormat dateFormat, String source) {
        try {
            return dateFormat.parse(source);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertCorrectDate(String date, String expectedDisplayDate, String expectedMachineDate) throws ParseException {
        DateUtils.assertCorrectDate(date, "dd MMMMM yyyy hh:mm aaa", "yyyy-MM-dd'T'HH:mm:ssZ", expectedDisplayDate, expectedMachineDate);
    }

    public static void assertCorrectDate(String date, String displayFormatString, String expectedDisplayDate, String expectedMachineDate) throws ParseException {
        DateUtils.assertCorrectDate(date, displayFormatString, "yyyy-MM-dd'T'HH:mm:ssZ", expectedDisplayDate, expectedMachineDate);
    }

    public static void assertCorrectDate(String date, String displayFormatString, String machineFormatString, String expectedDisplayDate, String expectedMachineDate) throws ParseException {
        SimpleDateFormat machineFormat = new SimpleDateFormat(machineFormatString);
        Date commitDate = machineFormat.parse(date);
        SimpleDateFormat displayFormat = new SimpleDateFormat(displayFormatString);
        String prettyDate = displayFormat.format(commitDate);
        Date actualMachineDate = machineFormat.parse(expectedMachineDate);
        Assert.assertEquals((String)"Display date is correct", (Object)prettyDate.toLowerCase(), (Object)expectedDisplayDate.toLowerCase());
        Assert.assertEquals((String)"Machine date is correct", (Object)commitDate, (Object)actualMachineDate);
    }
}

