/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketLoginPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupJiraIntegrationPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import org.openqa.selenium.By;

public final class SetupAdminUserPage
extends SetupPage {
    @ElementBy(id="username")
    private PageElement username;
    @ElementBy(id="password")
    private PageElement password;
    @ElementBy(id="confirmPassword")
    private PageElement confirmPassword;
    @ElementBy(id="fullname")
    private PageElement fullname;
    @ElementBy(id="email")
    private PageElement email;
    @ElementBy(id="skipJira")
    private PageElement skipJiraButton;
    @ElementBy(id="setupJira")
    private PageElement setupJiraButton;

    @Override
    public String getStepHeading() {
        return "Administrator account setup";
    }

    public SetupAdminUserPage setUsername(String name) {
        this.username.clear().type(new CharSequence[]{name});
        return this;
    }

    public SetupAdminUserPage setPassword(String name) {
        this.password.clear().type(new CharSequence[]{name});
        return this;
    }

    public SetupAdminUserPage setConfirmPassword(String name) {
        this.confirmPassword.clear().type(new CharSequence[]{name});
        return this;
    }

    public SetupAdminUserPage setFullname(String name) {
        this.fullname.clear().type(new CharSequence[]{name});
        return this;
    }

    public SetupAdminUserPage setEmail(String name) {
        this.email.clear().type(new CharSequence[]{name});
        return this;
    }

    public BitbucketLoginPage clickSkipJiraSuccess() {
        this.skipJiraButton.click();
        return (BitbucketLoginPage)this.pageBinder.bind(BitbucketLoginPage.class, new Object[0]);
    }

    public SetupAdminUserPage clickSkipJiraFail() {
        this.skipJiraButton.click();
        return this;
    }

    public SetupJiraIntegrationPage setupJira() {
        this.setupJiraButton.click();
        return (SetupJiraIntegrationPage)this.pageBinder.bind(SetupJiraIntegrationPage.class, new Object[0]);
    }

    public boolean hasUsernameWarning() {
        PageElement usernameWarning = this.elementFinder.find(By.cssSelector((String)"#username + .error"));
        return usernameWarning.isPresent() && usernameWarning.isVisible();
    }

    public boolean hasPasswordWarning() {
        PageElement passwordWarning = this.elementFinder.find(By.cssSelector((String)"#password + .error"));
        return passwordWarning.isPresent() && passwordWarning.isVisible();
    }

    public boolean hasPasswordConfirmationWarning() {
        PageElement confirmPasswordWarning = this.elementFinder.find(By.cssSelector((String)"#confirmPassword + .error"));
        return confirmPasswordWarning.isPresent() && confirmPasswordWarning.isVisible();
    }

    public boolean hasFullnameWarning() {
        PageElement fullnameWarning = this.elementFinder.find(By.cssSelector((String)"#fullname + .error"));
        return fullnameWarning.isPresent() && fullnameWarning.isVisible();
    }

    public boolean hasEmailWarning() {
        PageElement emailWarning = this.elementFinder.find(By.cssSelector((String)"#email + .error"));
        return emailWarning.isPresent() && emailWarning.isVisible();
    }
}

