/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.repository.sync;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.repository.sync.RefSyncBanner;
import com.atlassian.webdriver.bitbucket.page.repository.sync.RefSyncDialog;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class RefSyncSettingsPage
extends BitbucketPage {
    private final String projectKey;
    private final String repositorySlug;
    @ElementBy(id="enable-ref-syncing")
    private CheckboxElement enableRefSyncCheckbox;
    @ElementBy(className="not-available")
    private PageElement notAvailable;
    @ElementBy(className="sync-status")
    private PageElement syncStatus;

    public RefSyncSettingsPage(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Nonnull
    public RefSyncBanner getBanner() {
        return (RefSyncBanner)this.pageBinder.bind(RefSyncBanner.class, new Object[0]);
    }

    @Nonnull
    public Iterable<DivergedBranch> getDivergedBranches() {
        PageElement divergedRefs = this.syncStatus.find(By.className((String)"diverged-refs"));
        if (divergedRefs.isPresent()) {
            List rows = divergedRefs.findAll(By.tagName((String)"tr"));
            return Chainable.chain((Iterable)rows).transform(element -> (DivergedBranch)this.pageBinder.bind(DivergedBranch.class, new Object[]{element})).toList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public Date getLastSync() {
        PageElement lastSync = this.syncStatus.find(By.className((String)"last-sync"));
        if (lastSync.isPresent()) {
            String time = lastSync.find(By.tagName((String)"time")).getAttribute("datetime");
            return DateUtils.parse(DateUtils.getDateTimeFormat(), time);
        }
        return null;
    }

    @Nullable
    public String getNotAvailableMessage() {
        return this.notAvailable.isPresent() ? this.notAvailable.getText() : null;
    }

    @Nonnull
    public String getUrl() {
        return String.format("/plugins/servlet/sync/%1$s/%2$s", this.projectKey, this.repositorySlug);
    }

    public boolean hasStatus() {
        return (Boolean)this.syncStatusIsPresent().now();
    }

    public boolean isAvailable() {
        return !this.notAvailable.isPresent();
    }

    public boolean isEnabled() {
        return this.enableRefSyncCheckbox.isSelected();
    }

    public boolean hasEnableCheckbox() {
        return this.enableRefSyncCheckbox.isPresent();
    }

    public RefSyncSettingsPage setEnabled(boolean enabled) {
        if (enabled) {
            this.enableRefSyncCheckbox.check();
            Poller.waitUntilTrue((TimedQuery)this.syncStatusIsPresent());
        } else if (this.isEnabled()) {
            this.enableRefSyncCheckbox.uncheck();
            Poller.waitUntilFalse((TimedQuery)this.syncStatusIsPresent());
        }
        return this;
    }

    private TimedCondition syncStatusIsPresent() {
        return this.syncStatus.timed().isPresent();
    }

    public static class DivergedBranch {
        private final PageElement row;
        @Inject
        private PageBinder pageBinder;

        public DivergedBranch(PageElement row) {
            this.row = row;
        }

        @Nonnull
        public String getName() {
            return this.row.find(ByDataAttribute.byData((String)"column", (String)"ref-name")).find(By.cssSelector((String)".ref .name")).getText();
        }

        @Nonnull
        public RefSyncDialog synchronize() {
            this.row.find(By.className((String)"synchronize-ref")).click();
            RefSyncDialog dialog = (RefSyncDialog)this.pageBinder.bind(RefSyncDialog.class, new Object[0]);
            Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
            return dialog;
        }
    }
}

