/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AuiForm;
import com.atlassian.webdriver.bitbucket.element.Dialog;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.admin.repo.RepositoryHooksPage;
import org.openqa.selenium.By;

public class RepositoryHookDialog
extends BaseRepositoryPage {
    private static final String ID = "repository-hook-dialog";
    @ElementBy(id="repository-hook-dialog")
    private HookDialog hookDialog;
    private AuiForm form;

    public RepositoryHookDialog(String projectKey, String slug) {
        super(projectKey, slug);
    }

    @WaitUntil
    public void ensureFormLoaded() {
        this.form = (AuiForm)this.hookDialog.find(AuiForm.SELECTOR, AuiForm.class);
        Poller.waitUntilTrue((TimedQuery)this.form.timed().isVisible());
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/hooks", this.projectKey, this.slug);
    }

    @Override
    public boolean isHere() {
        return super.isHere() && (Boolean)this.hookDialog.isOpen().now() != false;
    }

    public AuiForm getForm() {
        return this.form;
    }

    private void enableNoBind() {
        PageElement enableButton = this.hookDialog.find(By.className((String)"button-panel-submit-button"));
        if (!"Enable".equals(enableButton.getText())) {
            throw new IllegalStateException();
        }
        enableButton.click();
    }

    public RepositoryHooksPage enable() {
        this.enableNoBind();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.id((String)ID)).timed().isPresent());
        return (RepositoryHooksPage)this.pageBinder.bind(RepositoryHooksPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryHookDialog enableWithErrors() {
        this.enableNoBind();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#repository-hook-dialog .error")).timed().isVisible());
        return this;
    }

    public RepositoryHooksPage disable() {
        this.hookDialog.find(By.className((String)"button-panel-disable-button")).click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.id((String)ID)).timed().isPresent());
        return (RepositoryHooksPage)this.pageBinder.bind(RepositoryHooksPage.class, new Object[]{this.projectKey, this.slug});
    }

    public static class HookDialog
    extends Dialog {
        public HookDialog(By locator) {
            super(locator);
        }

        public HookDialog(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public HookDialog(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        @Override
        public TimedCondition isOpen() {
            return this.find(By.className((String)"dialog-components"), TimeoutType.DIALOG_LOAD).timed().isVisible();
        }
    }
}

