/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.admin.FormFragment;
import com.atlassian.webdriver.bitbucket.page.admin.ServerSettingsPage;
import org.apache.commons.lang3.StringUtils;

public class SshAdminFormFragment
extends FormFragment<ServerSettingsPage> {
    @ElementBy(id="sshEnabled")
    private PageElement enabledCheckbox;
    @ElementBy(id="sshAccessKeysEnabled")
    private PageElement keyAccessEnabledCheckbox;
    @ElementBy(id="sshPort")
    private PageElement portTextField;
    @ElementBy(id="sshBaseUrl")
    private PageElement baseUrlTextField;

    public SshAdminFormFragment(ServerSettingsPage page) {
        super(page);
    }

    public boolean isEnabled() {
        return this.enabledCheckbox.isSelected();
    }

    public boolean isKeyAccessEnabled() {
        return this.keyAccessEnabledCheckbox.isSelected();
    }

    public SshAdminFormFragment toggleEnabled() {
        this.enabledCheckbox.toggle();
        return this;
    }

    public SshAdminFormFragment toggleKeyAccessEnabled() {
        this.keyAccessEnabledCheckbox.toggle();
        return this;
    }

    public String getPort() {
        return this.portTextField.getValue();
    }

    public SshAdminFormFragment setPort(String port) {
        this.portTextField.clear().type(new CharSequence[]{port});
        return this;
    }

    public SshAdminFormFragment setPort(Number port) {
        this.setPort(port.toString());
        return this;
    }

    public String getBaseUrl() {
        return StringUtils.defaultString((String)this.baseUrlTextField.getValue());
    }

    public SshAdminFormFragment setBaseUrl(String baseUrl) {
        this.baseUrlTextField.clear().type(new CharSequence[]{baseUrl});
        return this;
    }
}

