/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.CodeMirrorSourceFileContent;
import com.atlassian.webdriver.bitbucket.element.LegacySourceFileContent;
import com.atlassian.webdriver.bitbucket.element.SourceFileContent;
import com.atlassian.webdriver.bitbucket.page.FileContentPage;
import com.atlassian.webdriver.bitbucket.page.FileLayoutPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.By;

public class FileSourcePage
extends FileContentPage<SourceFileContent> {
    @ElementBy(className="source-view", pageElementClass=LegacySourceFileContent.class)
    private LegacySourceFileContent legacyFileContent;
    @ElementBy(className="source-view", pageElementClass=CodeMirrorSourceFileContent.class)
    private CodeMirrorSourceFileContent codemirrorFileContent;
    private Boolean isLegacy;
    @ElementBy(className="file-blame")
    protected PageElement blameButton;

    public FileSourcePage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, String commitId) {
        super(projectKey, repoSlug, path, new FileLayoutPage.RevisionSpecifier(commitId, null));
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    @Override
    public SourceFileContent getFileContent() {
        return this.codemirrorFileContent;
    }

    @Override
    protected String getPathComponent() {
        return "browse";
    }

    public Collection<String> getWarningMessages() {
        return ElementUtils.getElementTexts(this.getFileContent().findAll(By.className((String)"aui-message-warning")));
    }

    public FileSourcePage loadUntilRevision(String revision) {
        return this.loadRevision(revision, FileSourcePage.class);
    }

    public List<BlameRow> showBlame() {
        this.getFileContent().waitUntilFileContentLoaded();
        this.waitUntilEventFired("bitbucket.internal.feature.fileContent.fileBlameExpandedStateChanged", new Runnable(){

            @Override
            public void run() {
                FileSourcePage.this.blameButton.click();
            }
        });
        return this.getBlame(By.cssSelector((String)".blame[data-span]"), CodeMirrorBlameRow.class);
    }

    private <T extends BlameRow> List<BlameRow> getBlame(By locator, final Class<T> clazz) {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(locator).timed().isPresent());
        return Lists.transform((List)this.elementFinder.findAll(locator), (Function)new Function<PageElement, BlameRow>(){

            public BlameRow apply(PageElement element) {
                return (BlameRow)FileSourcePage.this.pageBinder.bind(clazz, new Object[]{element});
            }
        });
    }

    public static class CodeMirrorBlameRow
    implements BlameRow {
        public final PageElement firstLine;

        public CodeMirrorBlameRow(PageElement firstLine) {
            this.firstLine = firstLine;
        }

        @Override
        public String getAuthor() {
            return this.firstLine.find(By.className((String)"blame-author")).getAttribute("title");
        }

        @Override
        public String getCommit() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.className((String)"commitid")).getText();
        }

        @Override
        public String getDate() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.className((String)"blame-timestamp")).getText();
        }

        @Override
        public int getSpan() {
            return Integer.parseInt(this.firstLine.getAttribute("data-span"));
        }
    }

    public static interface BlameRow {
        public String getAuthor();

        public String getCommit();

        public String getDate();

        public int getSpan();
    }
}

