/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.BranchInfo;
import com.atlassian.webdriver.bitbucket.element.CommitMetadata;
import com.atlassian.webdriver.bitbucket.element.DiffFileContent;
import com.atlassian.webdriver.bitbucket.element.FileTree;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class CommitPage<P extends CommitPage<P, F>, F extends DiffFileContent>
extends BitbucketPage {
    public static final String COLLAPSED_CSS_CLASS = "collapsed";
    public static final String COMMIT_FILE_CONTAINER_CSS_CLASS = "commit-files";
    @ElementBy(className="commit-metadata", pageElementClass=CommitMetadata.class)
    protected CommitMetadata metadata;
    @ElementBy(className="commit-files")
    protected PageElement treeAndDiffView;
    @ElementBy(className="file-tree-container", pageElementClass=FileTree.class)
    protected FileTree tree;
    @ElementBy(className="collapse-file-tree")
    protected PageElement collapseFileTreeButton;
    @ElementBy(className="file-toolbar", pageElementClass=FileToolbar.class)
    protected FileToolbar fileToolbar;
    @ElementBy(className="user-avatar")
    protected PageElement avatar;
    protected final String projectKey;
    protected final String repoSlug;
    protected final String commitId;
    protected final String parentId;
    protected final String changePath;
    protected final Class<P> selfClass;

    public CommitPage(String projectKey, String repoSlug, String commitId, @Nonnull Class<P> selfClass) {
        this(projectKey, repoSlug, commitId, null, null, selfClass);
    }

    public CommitPage(String projectKey, String repoSlug, String commitId, String parentId, @Nonnull Class<P> selfClass) {
        this(projectKey, repoSlug, commitId, parentId, null, selfClass);
    }

    public CommitPage(String projectKey, String repoSlug, String commitId, String parentId, String changePath, @Nonnull Class<P> selfClass) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.commitId = commitId;
        this.parentId = parentId;
        this.changePath = changePath;
        this.selfClass = selfClass;
    }

    public abstract F getFileContent();

    public CommitMetadata getMetadata() {
        return this.metadata;
    }

    public FileToolbar getFileToolbar() {
        this.waitUntilFileContentLoaded();
        return this.fileToolbar;
    }

    public FileTree getTree() {
        this.tree.waitUntilLoaded();
        return this.tree;
    }

    public P waitUntilDiffTreeLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"file-tree")).find(By.tagName((String)"ul")).timed().isVisible());
        this.ensureFuncTestClass();
        return this.self();
    }

    public P waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.id((String)"commit-file-content")).find(By.className((String)"content-view")).timed().isVisible());
        return this.self();
    }

    public BranchInfo getBranchInfo() {
        return (BranchInfo)this.pageBinder.bind(BranchInfo.class, new Object[]{this.elementFinder.find(By.className((String)"branch-info-details")), this.projectKey, this.repoSlug});
    }

    @Override
    public void doWait() {
        super.doWait();
        this.waitUntilDiffTreeLoaded();
    }

    private void ensureFuncTestClass() {
        this.javascriptExecutor.executeScript("jQuery('.commit-files').removeClass('collapsed')", new Object[0]);
    }

    private <PP extends BitbucketPage> PP clickFileInternal(String path, boolean wait, Class<PP> nextPage, Object ... args) {
        this.waitUntilDiffTreeLoaded();
        this.tree.find(By.cssSelector((String)("[href=\"#" + path + "\"]"))).click();
        if (wait) {
            this.waitUntilFileContentLoaded();
        }
        return (PP)((BitbucketPage)this.pageBinder.bind(nextPage, args));
    }

    public P clickFile(String path) {
        return (P)((CommitPage)this.clickFileInternal(path, false, this.selfClass, this.projectKey, this.repoSlug, this.commitId, this.parentId, path));
    }

    public <PP extends BitbucketPage> PP clickFile(String path, Class<PP> nextPage, Object ... args) {
        return this.clickFileInternal(path, false, nextPage, args);
    }

    public String getUrl() {
        String url = "/projects/" + this.projectKey + "/repos/" + this.repoSlug + "/commits/" + this.commitId;
        if (this.parentId != null) {
            url = url + "?to=" + this.parentId;
        }
        if (this.changePath != null) {
            url = url + "#" + this.changePath;
        }
        return url;
    }

    public void moveToNextChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToNextSecondary(CommitPage.this.body);
            }
        });
    }

    public void moveToNextComment(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToNextTertiary(CommitPage.this.body);
            }
        });
    }

    public void moveToPreviousChange(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToPreviousSecondary(CommitPage.this.body);
            }
        });
    }

    public void moveToPreviousComment(boolean expectMovement) {
        this.navigateDiff(expectMovement, new Runnable(){

            @Override
            public void run() {
                KeyboardShortcuts.moveToPreviousTertiary(CommitPage.this.body);
            }
        });
    }

    private P self() {
        return (P)((CommitPage)this.selfClass.cast(this));
    }

    private void navigateDiff(boolean expectMovement, Runnable doNavigation) {
        if (expectMovement) {
            ElementUtils.waitUntilUpdated(this.getFileContent().find(By.className((String)"content-view")), doNavigation);
        } else {
            doNavigation.run();
        }
    }

    public static class FileToolbar
    extends LegacyElementPageObject {
        public FileToolbar(@Nonnull PageElement element) {
            super(element);
        }

        public FileToolbar(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public boolean hasSourceView() {
            return this.find(By.className((String)"source-view-link")).isVisible();
        }
    }
}

