/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.BitbucketHeader;
import com.atlassian.webdriver.bitbucket.element.ErrorDialog;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.LogoutPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;

public abstract class BitbucketPage
extends AbstractPage {
    @ElementBy(id="content")
    protected PageElement content;
    @ElementBy(id="footer")
    protected PageElement footer;
    @ElementBy(id="header")
    private PageElement header;

    public void assertIsError(String expectedMessage, int expectedError) {
        PageElement errorImage = this.content.find(By.className((String)"error-image"));
        Assert.assertTrue((String)"Error image not present", (boolean)errorImage.isPresent());
        Assert.assertTrue((String)("Error image does not have expected class _" + expectedError), (boolean)errorImage.hasClass("_" + expectedError));
        Assert.assertThat((Object)this.content.getText(), (Matcher)Matchers.containsString((String)expectedMessage));
    }

    public Collection<String> getAuiErrorMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-error")));
    }

    public Collection<String> getAuiSuccessMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-success")));
    }

    public Collection<String> getAuiWarningMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-warning")));
    }

    public ErrorDialog getErrorDialog() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"error-dialog")).timed().isVisible());
        return (ErrorDialog)((Object)this.body.findAll(By.className((String)"error-dialog"), ErrorDialog.class).get(0));
    }

    public List<String> getFieldsWithErrors(PageElement form) {
        return Lists.newArrayList(ElementUtils.getFieldsWithErrors(form));
    }

    public BitbucketHeader getHeader() {
        return (BitbucketHeader)this.pageBinder.bind(BitbucketHeader.class, new Object[]{this.header});
    }

    public boolean hasAdminLink() {
        return this.header.find(By.cssSelector((String)"a.admin-link")).isPresent();
    }

    public LogoutPage logout() {
        return this.getHeader().logout(LogoutPage.class);
    }

    protected void useShortcut(CharSequence key) {
        this.body.type(new CharSequence[]{key});
    }
}

