/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.ProjectSidebarNav;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.CommitListPage;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryEditSettingsPage;
import org.openqa.selenium.By;

public abstract class BaseRepositoryPage
extends BaseSidebarPage {
    @ElementBy(cssSelector="#content > .aui-sidebar .aui-navgroup-vertical", pageElementClass=ProjectSidebarNav.class)
    private ProjectSidebarNav items;
    protected final String projectKey;
    protected final String slug;

    public BaseRepositoryPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public ProjectSidebarNav getItems() {
        return this.items;
    }

    public RepositoryEditSettingsPage goToEditSettingsPage() {
        this.items.clickSettingsItem();
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public FileBrowserPage goToFilesPage() {
        this.items.clickRepositoriesItem();
        return (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{this.projectKey, this.slug});
    }

    public CommitListPage goToCommitsPage() {
        this.items.clickCommitsItem();
        return (CommitListPage)this.pageBinder.bind(CommitListPage.class, new Object[]{this.projectKey, this.slug});
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getSlug() {
        return this.slug;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }
}

