/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

public abstract class Select2<S extends Select2<S, O>, O extends Option>
extends AbstractElementPageObject {
    protected static final String NO_RESULTS_CLASS = "select2-no-results";
    protected static final String SEARCH_FIELD_CLASS = "select2-search-field";
    protected static final String INPUT_FIELD_CLASS = "select2-input";
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    @ElementBy(id="select2-drop", timeoutType=TimeoutType.AJAX_ACTION)
    private PageElement dropdown;
    protected final Class<O> optionClass;

    protected Select2(@Nonnull PageElement container, @Nonnull Class<O> optionClass) {
        super(container);
        this.optionClass = (Class)Preconditions.checkNotNull(optionClass);
    }

    @Nonnull
    public S clearFilter() {
        this.getInput().clear();
        Poller.waitUntilFalse((TimedQuery)this.isInputActive());
        return this.self();
    }

    @Nonnull
    public TimedQuery<Integer> getOptionCount() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

            public Integer get() {
                return Iterables.size((Iterable)((Iterable)Select2.this.getOptions().now()));
            }
        });
    }

    @Nonnull
    public TimedQuery<Iterable<O>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Iterable<O>>(){

            public Iterable<O> get() {
                if (!((Boolean)Select2.this.isOptionsOpen().now()).booleanValue()) {
                    return Collections.emptyList();
                }
                return Chainable.chain((Iterable)Select2.this.getOptionsContainer().findAll(Locators.listItem())).filter(element -> !element.hasClass(Select2.NO_RESULTS_CLASS)).transform(ElementUtils.bind(Select2.this.pageBinder, Select2.this.optionClass, new Object[0])).toList();
            }
        });
    }

    @Nonnull
    public TimedQuery<Integer> getSelectedOptionCount() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

            public Integer get() {
                return Iterables.size((Iterable)((Iterable)Select2.this.getSelectedOptions().now()));
            }
        });
    }

    @Nonnull
    public TimedQuery<Iterable<O>> getSelectedOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Iterable<O>>(){

            public Iterable<O> get() {
                if (((Boolean)Select2.this.isDropDown().now()).booleanValue()) {
                    return Chainable.chain((Iterable)Select2.this.getSelectedOptionContainer().findAll(By.className((String)"select2-chosen"))).transform(ElementUtils.bind(Select2.this.pageBinder, Select2.this.optionClass, new Object[0])).toList();
                }
                return Chainable.chain((Iterable)Select2.this.getSelectedOptionsContainer().findAll(Locators.listItem())).filter(element -> !element.hasClass(Select2.SEARCH_FIELD_CLASS)).transform(ElementUtils.bind(Select2.this.pageBinder, Select2.this.optionClass, new Object[0])).toList();
            }
        });
    }

    @Nonnull
    public TimedCondition hasNoOptions() {
        return this.getOptionsContainer().find(By.className((String)NO_RESULTS_CLASS)).timed().isPresent();
    }

    @Nonnull
    public TimedCondition isMultiSelect() {
        return this.container.timed().hasClass("select2-container-multi");
    }

    @Nonnull
    public TimedCondition isDropDown() {
        return this.getSelectedOptionContainer().timed().isPresent();
    }

    @Nonnull
    public TimedCondition isOptionsOpen() {
        return this.dropdown.timed().isVisible();
    }

    @Nonnull
    public S openOptions() {
        if (((Boolean)this.isMultiSelect().now()).booleanValue()) {
            this.type(new CharSequence[]{Keys.ARROW_DOWN});
        } else if (((Boolean)this.isDropDown().now()).booleanValue()) {
            this.getSelectedOptionContainer().click();
        } else {
            this.container.find(By.className((String)"select2-default")).click();
        }
        Poller.waitUntilTrue((TimedQuery)this.isOptionsOpen());
        return this.self();
    }

    @Nonnull
    public S removeOption(@Nonnull O option) {
        Preconditions.checkNotNull(option, (Object)"option");
        String optionInfo = ((Option)option).toString();
        Poller.waitUntilTrue((String)String.format("Unable to remove option '%s', remove link not visible", optionInfo), (TimedQuery)((Option)option).getRemoveLink().timed().isVisible());
        int selectedCount = (Integer)this.getSelectedOptionCount().now();
        ((Option)option).getRemoveLink().click();
        Poller.waitUntilEquals((String)("Selected option count expected to decrease by 1 after removing option " + optionInfo), (Object)(selectedCount - 1), this.getSelectedOptionCount());
        return this.self();
    }

    @Nonnull
    public S removeAll() {
        Option selected = (Option)Iterables.getFirst((Iterable)((Iterable)this.getSelectedOptions().now()), null);
        while (selected != null) {
            this.removeOption(selected);
            selected = (Option)Iterables.getFirst((Iterable)((Iterable)this.getSelectedOptions().now()), null);
        }
        return this.self();
    }

    @Nonnull
    public S selectOption(@Nonnull O option) {
        Preconditions.checkNotNull(option, (Object)"option");
        Poller.waitUntilTrue((TimedQuery)((Option)option).container.timed().isVisible());
        ((Option)option).container.click();
        Poller.waitUntilFalse((TimedQuery)this.isOptionsOpen());
        return this.self();
    }

    @Nonnull
    public S selectFirst() {
        Poller.waitUntilEquals((String)("Expected only one option available, but was: " + this.getOptions().now()), (Object)1, this.getOptionCount());
        return this.selectOption((Option)Iterables.getFirst((Iterable)((Iterable)this.getOptions().now()), null));
    }

    @Nonnull
    public S type(CharSequence ... filter) {
        this.getInput().type(filter);
        Poller.waitUntilFalse((TimedQuery)this.isInputActive());
        return this.self();
    }

    @Nullable
    protected O findOption(@Nonnull Predicate<O> optionPredicate) {
        if (!((Boolean)this.isOptionsOpen().now()).booleanValue()) {
            return null;
        }
        return (O)((Option)Iterables.find((Iterable)((Iterable)this.getOptions().now()), optionPredicate, null));
    }

    @Nullable
    protected O findSelectedOption(@Nonnull Predicate<O> optionPredicate) {
        return (O)((Option)Iterables.find((Iterable)((Iterable)this.getSelectedOptions().now()), optionPredicate, null));
    }

    @Nonnull
    protected PageElement getSelectedOptionContainer() {
        return this.find(By.className((String)"select2-choice"));
    }

    @Nonnull
    protected PageElement getSelectedOptionsContainer() {
        return this.find(By.className((String)"select2-choices"));
    }

    @Nonnull
    protected PageElement getOptionsContainer() {
        return this.dropdown.find(By.className((String)"select2-results"));
    }

    @Nonnull
    protected PageElement getInput() {
        if (((Boolean)this.isMultiSelect().now()).booleanValue()) {
            return this.find(By.className((String)INPUT_FIELD_CLASS));
        }
        return this.dropdown.find(By.className((String)INPUT_FIELD_CLASS));
    }

    @Nonnull
    protected TimedCondition hasOption(final @Nonnull Predicate<O> optionPredicate) {
        return Conditions.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return Select2.this.findOption(optionPredicate) != null;
            }
        });
    }

    @Nonnull
    protected TimedCondition hasSelectedOption(final @Nonnull Predicate<O> optionPredicate) {
        return Conditions.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return Select2.this.findSelectedOption(optionPredicate) != null;
            }
        });
    }

    @Nonnull
    protected TimedCondition isInputActive() {
        return this.getInput().timed().hasClass("select2-active");
    }

    @Nonnull
    protected abstract S self();

    @Deprecated
    public Select2 add(String text, final Predicate<PageElement> predicate) {
        this.type(text);
        Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                for (PageElement element : Select2.this.elementFinder.findAll(By.className((String)"select2-result-selectable"))) {
                    if (!predicate.apply((Object)element)) continue;
                    try {
                        Select2.this.clickAndWaitForChoiceToBeAdded(element);
                        return true;
                    }
                    catch (StaleElementReferenceException staleElementReferenceException) {
                    }
                }
                return false;
            }
        }));
        return this;
    }

    @Deprecated
    public boolean canAdd(String text, Predicate<PageElement> predicate) {
        this.type(text);
        PageElement dropdown = this.elementFinder.find(By.id((String)"select2-drop"));
        List results = dropdown.findAll(By.className((String)"select2-result"));
        boolean canAdd = Iterables.any((Iterable)results, predicate);
        this.type(new CharSequence[]{Keys.ESCAPE});
        return canAdd;
    }

    private void clickAndWaitForChoiceToBeAdded(PageElement e) {
        int initialSize = this.countSelected();
        e.click();
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

            public Integer get() {
                return Select2.this.countSelected();
            }
        }), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(initialSize)));
    }

    private int countSelected() {
        return this.container.findAll(By.className((String)"select2-search-choice")).size();
    }

    private List<PageElement> getChoices() {
        return this.container.findAll(By.cssSelector((String)".select2-choices .select2-search-choice"));
    }

    public Select2 remove(Predicate<PageElement> predicate) {
        for (PageElement e : Lists.reverse(this.getChoices())) {
            if (!predicate.apply((Object)e)) continue;
            int count = this.countSelected() - 1;
            e.find(By.className((String)"select2-search-choice-close")).click();
            Poller.waitUntilEquals((Object)count, (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

                public Integer get() {
                    return Select2.this.countSelected();
                }
            }));
        }
        return this;
    }

    public <T> List<T> getValues(Function<PageElement, T> f) {
        return this.getChoices().stream().map(f).collect(Collectors.toList());
    }

    public static class Option {
        protected static final Function<? extends Option, PageElement> TO_CONTAINER = new Function<Option, PageElement>(){

            @Override
            public PageElement apply(Option option) {
                return option.container;
            }
        };
        protected final PageElement container;

        public Option(@Nonnull PageElement container) {
            this.container = (PageElement)Preconditions.checkNotNull((Object)container, (Object)"container");
        }

        @Nonnull
        public <T extends Option> T as(Class<T> targetType) {
            return (T)((Option)((Class)Preconditions.checkNotNull(targetType, (Object)"targetType")).cast(this));
        }

        @Nullable
        public String getText() {
            return this.container.getText();
        }

        public final String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
            try {
                toStringHelper.add("text", (Object)this.getText());
                this.extendToString(toStringHelper);
            }
            catch (WebDriverException e) {
                toStringHelper.add("exception", (Object)e.getMessage());
            }
            return toStringHelper.toString();
        }

        protected void extendToString(Objects.ToStringHelper toStringHelper) {
        }

        @Nonnull
        protected static <O extends Option> Function<O, PageElement> toContainer(@Nonnull Class<O> optionClass) {
            return TO_CONTAINER;
        }

        @Nonnull
        protected PageElement getRemoveLink() {
            return this.container.find(By.className((String)"select2-search-choice-close"));
        }
    }
}

