/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.NavItem;
import java.util.Collection;
import java.util.Collections;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

public class ProjectSidebarNav
extends LegacyElementPageObject {
    public ProjectSidebarNav(PageElement pageElement) {
        super(pageElement);
    }

    public ProjectSidebarNav(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public Collection<NavItem> getNavItems() {
        try {
            return this.findAll(By.cssSelector((String)".aui-nav > li"), NavItem.class);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyList();
        }
    }

    public PageElement getSettingsButton() {
        return this.find(By.cssSelector((String)".aui-sidebar .sidebar-settings-group .aui-sidebar-settings-button > a"));
    }

    public boolean hasSettingsButton() {
        return this.getSettingsButton().isPresent();
    }

    public NavItem getRepositoriesItem() {
        return this.getItem("repositories-nav");
    }

    public NavItem getCommitsItem() {
        return this.getItem("commits-nav");
    }

    public boolean hasCommitsItem() {
        return this.getCommitsItem() != null;
    }

    public boolean hasRepositoriesItem() {
        return this.getRepositoriesItem() != null;
    }

    public NavItem getItem(String className) {
        for (NavItem tab : this.getNavItems()) {
            if (!tab.hasClass(className)) continue;
            return tab;
        }
        return null;
    }

    public void clickSettingsItem() {
        PageElement settingsTabItem = this.getSettingsButton();
        if (settingsTabItem == null) {
            throw new NoSuchElementException("Settings tab not found");
        }
        settingsTabItem.click();
    }

    public void clickRepositoriesItem() {
        NavItem repoTabItem = this.getRepositoriesItem();
        if (repoTabItem == null) {
            throw new NoSuchElementException("Repositories tab not found");
        }
        repoTabItem.click();
    }

    public void clickCommitsItem() {
        NavItem repoTabItem = this.getCommitsItem();
        if (repoTabItem == null) {
            throw new NoSuchElementException("Commits tab not found");
        }
        repoTabItem.click();
    }
}

