/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.PermissionKind;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class PermissionRow
extends LegacyElementPageObject {
    public PermissionRow(PageElement pageElement) {
        super(pageElement);
    }

    public PermissionRow(By locator) {
        super(locator);
    }

    public PermissionRow(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public PermissionRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public PermissionKind getHighestPermission() {
        for (PageElement input : this.findAll(By.tagName((String)"input"))) {
            if (!input.isSelected()) continue;
            return PermissionKind.valueOf(input.getValue());
        }
        return null;
    }

    public PermissionRow clickPermission(PermissionKind permissionValue) {
        this.find(By.cssSelector((String)("input[value=\"" + permissionValue.name() + "\"]"))).click();
        Poller.waitUntilFalse((TimedQuery)this.find(By.className((String)"spinner")).timed().isVisible());
        return this;
    }

    public PermissionRow clickPermissionAndExpectError(PermissionKind permissionValue) {
        this.find(By.cssSelector((String)("input[value=\"" + permissionValue.name() + "\"]"))).click();
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<List<String>>(){

            public List<String> get() {
                return PermissionRow.this.getErrors();
            }
        }), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        return this;
    }

    public List<String> getErrors() {
        String entityId = this.getAttribute("data-entity-id");
        return Lists.transform((List)this.driver.findElements(By.cssSelector((String)("tr[data-entity-id=\"" + entityId + "\"].permission-error"))), (Function)new Function<WebElement, String>(){

            public String apply(WebElement error) {
                return error.getText().trim();
            }
        });
    }

    public PermissionRow clickRemove() {
        return this.clickRemoveAndWaitFor((TimedQuery<Boolean>)Conditions.not((TimedQuery)this.timed().isPresent()));
    }

    public PermissionRow clickRemoveAndExpectError() {
        return this.clickRemoveAndWaitFor((TimedQuery<Boolean>)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !PermissionRow.this.getErrors().isEmpty();
            }
        }));
    }

    private PermissionRow clickRemoveAndWaitFor(TimedQuery<Boolean> condition) {
        ElementUtils.displayAllDeleteButtons((JavascriptExecutor)WebDriverUtil.as((WebDriver)this.driver, JavascriptExecutor.class));
        this.find(By.className((String)"delete-button")).click();
        Poller.waitUntilTrue(condition);
        return this;
    }
}

