/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.CommentForm;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class GeneralCommentForm
extends CommentForm<GeneralCommentForm> {
    public GeneralCommentForm(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    private List<Comment> getGeneralComments() {
        return this.elementFinder.findAll(By.cssSelector((String)"#pull-request-activity .comment"), Comment.class);
    }

    private TimedQuery<Iterable<Comment>> getGeneralCommentsQuery() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Iterable<Comment>>(){

            public Iterable<Comment> get() {
                return GeneralCommentForm.this.getGeneralComments();
            }
        });
    }

    @Override
    public Comment submit() {
        List<Comment> oldComments = this.submitComment();
        Poller.waitUntil(this.getGeneralCommentsQuery(), (Matcher)Matchers.iterableWithSize((int)(oldComments.size() + 1)));
        return this.getNewComment(oldComments);
    }

    public void submitExpectingErrors() {
        this.submitComment();
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return GeneralCommentForm.this.hasErrors();
            }
        }), (Matcher)Matchers.equalTo((Object)true));
    }

    public void expand() {
        this.getTextArea().javascript().form().focus();
        this.waitForSubmitButton();
    }

    private List<Comment> submitComment() {
        List<Comment> oldComments = this.getGeneralComments();
        this.expand();
        this.getCommentButton().click();
        return oldComments;
    }

    private void waitForSubmitButton() {
        Poller.waitUntilFalse((TimedQuery)this.timed().hasClass("collapsed"));
    }

    private Comment getNewComment(List<Comment> oldComments) {
        final List<Long> oldIds = GeneralCommentForm.toIdList(oldComments);
        return (Comment)((Object)Iterables.find(this.getGeneralComments(), (Predicate)new Predicate<Comment>(){

            public boolean apply(Comment comment) {
                return !oldIds.contains(comment.getCommentId());
            }
        }));
    }
}

