/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.compare;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.element.SourceTargetSelector;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.openqa.selenium.By;

public abstract class ComparePage
extends BaseRepositoryPage {
    protected String tab;
    @ElementBy(className="swap-button")
    private PageElement swapBranchesButton;
    @ElementBy(id="show-create-pr-button")
    private PageElement createPullRequestButton;

    public ComparePage(String projectKey, String slug, String tab) {
        super(projectKey, slug);
        this.tab = tab;
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/compare/%s", this.projectKey, this.slug, this.tab);
    }

    public String getSourceBranchFromUrl() {
        return UrlUtils.getQueryParams(this.driver.getCurrentUrl()).get("sourceBranch");
    }

    public String getTargetBranchFromUrl() {
        return UrlUtils.getQueryParams(this.driver.getCurrentUrl()).get("targetBranch");
    }

    public <T extends ComparePage> T clickSwapBranches() {
        this.swapBranchesButton.click();
        return (T)((ComparePage)this.pageBinder.bind(this.getClass(), new Object[]{this.projectKey, this.slug}));
    }

    public SourceTargetSelector getSourceTargetSelector() {
        return (SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0]);
    }

    public LinkElement getCreatePullRequestToolbarAction() {
        return (LinkElement)((Object)Iterables.find(this.getSidebar().getActionsLinks(), (Predicate)new Predicate<LinkElement>(){

            public boolean apply(LinkElement link) {
                return link.find(By.className((String)"icon-create-pull-request")).isPresent();
            }
        }));
    }

    public abstract ComparePage switchTab();

    public abstract ComparePage switchTabUsingKeyboard();

    protected <T extends ComparePage> T switchTab(Class<T> pageClass, String tabName) {
        this.elementFinder.find(By.cssSelector((String)(".menu-item[data-module-key=compare-" + tabName + "-tab] strong"))).click();
        return (T)((ComparePage)this.pageBinder.bind(pageClass, new Object[]{this.projectKey, this.slug}));
    }

    protected <T extends ComparePage> T switchTab(Class<T> pageClass, char keyboardKey) {
        this.useShortcut(Character.toString(keyboardKey));
        return (T)((ComparePage)this.pageBinder.bind(pageClass, new Object[]{this.projectKey, this.slug}));
    }

    public PullRequestCreatePage createPullRequest() {
        this.createPullRequestButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public boolean isPullRequestButtonEnabled() {
        return this.createPullRequestButton.getAttribute("disabled") == null;
    }
}

