/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryImportSelectPage;
import com.atlassian.webdriver.bitbucket.util.EventUtils;
import org.openqa.selenium.By;

public class RepositoryImportLandingPage
extends BitbucketPage {
    @ElementBy(cssSelector="button[data-source='BITBUCKET_CLOUD']")
    private PageElement bitbucketCloudButton;
    @ElementBy(cssSelector="button[data-source='GITHUB']")
    private PageElement gitHubButton;
    @ElementBy(cssSelector="button[data-source='GIT']")
    private PageElement gitButton;
    @ElementBy(cssSelector=".active")
    private PageElement activeArea;
    @ElementBy(name="connect")
    private PageElement connectButton;
    @ElementBy(name="cancel")
    private PageElement cancel;
    @ElementBy(className="import-page-body")
    private PageElement form;
    private final String projectKey;

    public RepositoryImportLandingPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public RepositoryImportLandingPage clickConnectFail() {
        this.connectButton.click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"spinner-button")).timed().hasClass("spinning"));
        return this;
    }

    public RepositoryImportSelectPage clickConnect() {
        this.connectButton.click();
        return (RepositoryImportSelectPage)this.pageBinder.bind(RepositoryImportSelectPage.class, new Object[]{this.projectKey});
    }

    public RepositoryImportLandingPage clickBitbucketCloud() {
        this.bitbucketCloudButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"div[data-source='BITBUCKET_CLOUD']")).timed().hasClass("active"));
        return this;
    }

    public RepositoryImportLandingPage clickGitHub() {
        this.gitHubButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"div[data-source='GITHUB']")).timed().hasClass("active"));
        return this;
    }

    public RepositoryImportLandingPage clickGit() {
        this.gitButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"div[data-source='GIT']")).timed().hasClass("active"));
        return this;
    }

    public RepositoryImportLandingPage clickActiveArea() {
        this.waitUntilEventFired("bitbucket.internal.importer.form.validated", () -> this.activeArea.click());
        return this;
    }

    public Long clickImport() {
        Poller.waitUntilTrue((TimedQuery)this.connectButton.timed().isEnabled());
        EventUtils.waitUntilEventFired("bitbucket.internal.importer.job.created", () -> this.connectButton.click(), this.javascriptExecutor, this.timeouts, TimeoutType.AJAX_ACTION);
        return (Long)this.javascriptExecutor.executeScript("return require('bitbucket/internal/import-form')._getState().importing.jobId;", new Object[0]);
    }

    public String getUrl() {
        return "/plugins/servlet/import-repository/" + this.projectKey + "#landing-page";
    }

    public RepositoryImportLandingPage setCloneUrl(String url) {
        PageElement cloneUrl = this.elementFinder.find(By.cssSelector((String)".active input[name='url']"));
        cloneUrl.clear();
        cloneUrl.type(new CharSequence[]{url});
        return this;
    }

    public RepositoryImportLandingPage setUsername(String name) {
        PageElement username = this.elementFinder.find(By.cssSelector((String)".active input[name='username']"));
        username.clear();
        username.type(new CharSequence[]{name});
        return this;
    }

    public RepositoryImportLandingPage setPassword(String name) {
        PageElement passwordField = this.elementFinder.find(By.cssSelector((String)".active input[name='password']"));
        passwordField.clear();
        passwordField.type(new CharSequence[]{name});
        return this;
    }

    public String getCloneUrlError() {
        return this.elementFinder.find(By.cssSelector((String)".active div[data-property='source.url'] .error")).getText();
    }

    public String getPasswordError() {
        return this.elementFinder.find(By.cssSelector((String)".active div[data-property='credential.password'] .error")).getText();
    }

    public boolean isImportButtonEnabled() {
        return (Boolean)this.connectButton.timed().isEnabled().byDefaultTimeout();
    }
}

