/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.GitLfsRepositorySettingsFormFragment;
import com.atlassian.webdriver.bitbucket.page.RepositoryDeleteConfirmationPage;
import java.util.List;
import org.openqa.selenium.By;

public class RepositoryEditSettingsPage
extends BaseRepositoryPage {
    @ElementBy(name="name")
    private PageElement slugField;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(id="repository-settings-delete-button")
    private PageElement deleteButton;
    @ElementBy(className="stash-repository-edit-settings-form")
    private PageElement form;

    public RepositoryEditSettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public GitLfsRepositorySettingsFormFragment getGitLfsRepositorySettingsFormFragment() {
        return (GitLfsRepositorySettingsFormFragment)this.pageBinder.bind(GitLfsRepositorySettingsFormFragment.class, new Object[]{this});
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings", this.projectKey, this.slug);
    }

    public RepositoryEditSettingsPage setSlug(String slug) {
        this.slugField.clear();
        this.slugField.type(new CharSequence[]{slug});
        return this;
    }

    public String getSlugValue() {
        return this.slugField.getValue();
    }

    public boolean isDeleteShowing() {
        return this.deleteButton.isPresent();
    }

    public RepositoryDeleteConfirmationPage clickDelete() {
        this.deleteButton.click();
        return (RepositoryDeleteConfirmationPage)this.pageBinder.bind(RepositoryDeleteConfirmationPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage submitSuccess() {
        String slug = this.slugField.getValue();
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                RepositoryEditSettingsPage.this.submitButton.click();
            }
        });
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, slug});
    }

    public RepositoryEditSettingsPage submitFail() {
        this.submitButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#submit:enabled")).timed().isPresent());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.form);
    }

    public boolean isSlugFieldWithError() {
        return this.getFieldsWithErrors().contains("name");
    }
}

