/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverCheckboxElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryEditSettingsPage;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;

public class PullRequestRepositorySettingsPage
extends BaseRepositoryPage {
    @ElementBy(className="merge-strategies")
    private PageElement mergeConfig;
    @ElementBy(id="requiredApprovers")
    private WebDriverCheckboxElement requiredApprovers;
    @ElementBy(id="requiredApproversCount")
    private PageElement requiredApproversCount;
    @ElementBy(id="requirePullRequestTasksResolved")
    private WebDriverCheckboxElement requireTasksCompletedCheckbox;
    @ElementBy(id="require-all-approvers-for-merge")
    private WebDriverCheckboxElement requireAllApprovalsCheckbox;
    @ElementBy(cssSelector="form.pull-request-settings #submit")
    private PageElement saveButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;

    public PullRequestRepositorySettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public void disableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.name((String)"enabledIds")).stream().filter(element -> {
            String checked = element.getAttribute("checked");
            return checked != null && strategyIds.contains(element.getId());
        }).forEach(PageElement::click);
    }

    public void enableMergeStrategies(Set<String> strategyIds) {
        this.mergeConfig.findAll(By.name((String)"enabledIds")).stream().filter(element -> {
            String checked = element.getAttribute("checked");
            return checked == null && strategyIds.contains(element.getId());
        }).forEach(PageElement::click);
    }

    public String getDefaultMergeStrategy() {
        return this.mergeConfig.find(By.className((String)"default-merge-checked")).getAttribute("data-strategy-id");
    }

    public List<String> getEnabledMergeStrategies() {
        return (List)this.mergeConfig.findAll(By.name((String)"enabledIds")).stream().filter(pageElement -> pageElement.getAttribute("checked") != null).map(PageElement::getId).collect(MoreCollectors.toImmutableList());
    }

    public List<String> getStrategiesWithDefaultLink() {
        return (List)this.mergeConfig.findAll(By.className((String)"default-merge-strategy")).stream().filter(element -> element.isEnabled() && element.getAttribute("checked") == null).map(PageElement::getValue).collect(MoreCollectors.toImmutableList());
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/pull-requests", this.projectKey, this.slug);
    }

    public int getNumberOfRequiredApprovers() {
        if (this.requiredApprovers.isSelected()) {
            return Integer.parseInt(this.requiredApproversCount.getValue());
        }
        return 0;
    }

    public void setDefaultMergeStrategy(String defaultId) {
        this.mergeConfig.findAll(By.className((String)"default-merge-strategy-label")).stream().filter(element -> defaultId.equals(element.getAttribute("data-strategy-id"))).forEach(PageElement::click);
    }

    public PullRequestRepositorySettingsPage setNumberOfRequiredApprovers(int n) {
        if (n == 0) {
            this.requiredApprovers.uncheck();
        } else {
            this.requiredApprovers.check();
            Poller.waitUntilTrue((TimedQuery)this.requiredApproversCount.timed().isEnabled());
            PageElement option = this.requiredApproversCount.find(By.cssSelector((String)String.format("option[value='%d']", n)));
            if (!option.isPresent()) {
                throw new IllegalArgumentException("Unsupported number of approvers: " + n);
            }
            option.select();
        }
        return this;
    }

    public PullRequestRepositorySettingsPage setRequireAllApprovals(boolean requireAllApprovals) {
        if (requireAllApprovals) {
            this.requireAllApprovalsCheckbox.check();
        } else {
            this.requireAllApprovalsCheckbox.uncheck();
        }
        return this;
    }

    public PullRequestRepositorySettingsPage setRequireTasksCompleted(boolean requireTasksCompleted) {
        if (requireTasksCompleted) {
            this.requireTasksCompletedCheckbox.check();
        } else {
            this.requireTasksCompletedCheckbox.uncheck();
        }
        return this;
    }

    public PullRequestRepositorySettingsPage clickSave() {
        this.scrollToBottom();
        this.waitForPageLoad(() -> ((PageElement)this.saveButton).click());
        return (PullRequestRepositorySettingsPage)this.pageBinder.bind(PullRequestRepositorySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage clickCancel() {
        this.waitForPageLoad(() -> ((PageElement)this.cancelLink).click());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }
}

