/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class AboutPage
extends BitbucketPage {
    @ElementBy(cssSelector=".aui-page-panel-content .copyright")
    private PageElement copyrightStatement;
    @ElementBy(cssSelector=".aui-page-panel-content .licenses")
    private PageElement licenses;
    @ElementBy(cssSelector=".aui-page-panel-content .authors")
    private PageElement authors;

    public String getUrl() {
        return "/about";
    }

    public boolean hasCopyrightNotice() {
        Pattern copyrightPattern = Pattern.compile("Copyright \u00a9 2012( - \\d{4})? Atlassian Corporation Pty Ltd.");
        return copyrightPattern.matcher(this.copyrightStatement.getText()).find();
    }

    public List<String> getAuthors() {
        return ImmutableList.copyOf(ElementUtils.getElementTexts(this.authors.findAll(By.tagName((String)"li"))));
    }

    public List<String> getLibraries() {
        return ImmutableList.copyOf(ElementUtils.getElementTexts(this.licenses.findAll(By.tagName((String)"li"))));
    }
}

