/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.GroupSelect;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class UserGroupsTable
extends AbstractElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;
    @ElementBy(className="add-button")
    private PageElement addButton;
    private GroupSelect groupsPicker;
    private Long lastUpdated;

    public UserGroupsTable(@Nonnull PageElement container) {
        super(container);
    }

    @WaitUntil
    protected void waitUntilLoaded() {
        ElementUtils.waitUntilUpdated(this.container, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.container);
    }

    @Init
    protected void initGroupPicker() {
        this.groupsPicker = (GroupSelect)this.pageBinder.bind(GroupSelect.class, new Object[]{this.container.find(By.className((String)"groups-multi-selector"))});
    }

    public UserGroupsTable loadNextPage() {
        ElementUtils.scrollDocumentAndWait(this.container);
        return this;
    }

    public UserGroupsTable add(String name) {
        return this.add(name, false);
    }

    public UserGroupsTable add(String name, boolean expectError) {
        this.groupsPicker.add(name, new GroupPredicate(name));
        this.addButton.click();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public UserGroupsTable remove(String name) {
        return this.remove(name, false);
    }

    public UserGroupsTable remove(String name, boolean expectError) {
        this.find(name).delete();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public boolean canAdd(String name) {
        return this.groupsPicker.canAdd(name, new GroupPredicate(name));
    }

    public List<Row> list() {
        return this.container.findAll(By.cssSelector((String)"tbody > tr"), Row.class);
    }

    public Row find(final String name) {
        return (Row)((Object)Iterables.find(this.list(), (Predicate)new Predicate<Row>(){

            public boolean apply(Row row) {
                return row.getName().equals(name);
            }
        }, null));
    }

    private void waitErrorMessage() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-message-error")).timed().isVisible());
    }

    private static class GroupPredicate
    implements Predicate<PageElement> {
        private final String name;

        public GroupPredicate(String name) {
            this.name = name;
        }

        public boolean apply(PageElement result) {
            return result.getText().equals(this.name);
        }
    }

    public static class Row
    extends LegacyElementPageObject {
        public Row(@Nonnull PageElement container) {
            super(container);
        }

        public Row(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getName() {
            return this.find(By.cssSelector((String)"[data-groupname]")).getAttribute("data-groupname");
        }

        public void delete() {
            PageElement delete = this.getDeleteButton();
            ElementUtils.makeVisible(delete);
            delete.click();
        }

        private PageElement getDeleteButton() {
            return this.find(By.className((String)"delete-button"));
        }
    }
}

