/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.By;

public class GroupOption
extends IdOption {
    public static final Function<GroupOption, String> TO_GROUP_NAME = new Function<GroupOption, String>(){

        public String apply(@Nullable GroupOption option) {
            return option.getGroupName();
        }
    };

    public GroupOption(PageElement container) {
        super(container);
    }

    @Nonnull
    public static Predicate<GroupOption> groupNameMatches(@Nonnull String groupName) {
        return GroupOption.idMatches(GroupOption.class, groupName);
    }

    @Nullable
    public String getGroupName() {
        return this.getGroupContainer().getAttribute("data-groupname");
    }

    @Override
    @Nullable
    public String getId() {
        return this.getGroupName();
    }

    @Nonnull
    protected PageElement getGroupContainer() {
        return this.container.find(By.className((String)"group-avatar"));
    }

    @Override
    protected void extendToString(Objects.ToStringHelper toStringHelper) {
        toStringHelper.add("groupName", (Object)this.getGroupName());
    }
}

