/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.secretscanning;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.secretscanning.SecretScanningListPage;
import jakarta.annotation.Nullable;
import java.util.List;
import org.openqa.selenium.By;

public abstract class SecretScanningRulePage<T extends SecretScanningRulePage<T>>
extends BitbucketAdminPage {
    @ElementBy(name="lineRegex")
    private PageElement linePattern;
    @ElementBy(name="name")
    private PageElement name;
    @ElementBy(name="pathRegex")
    private PageElement pathPattern;
    @ElementBy(className="save-button")
    private PageElement saveButton;

    public SecretScanningRulePage() {
    }

    public SecretScanningRulePage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public T setName(String value) {
        this.name.clear();
        this.name.type(new CharSequence[]{value});
        return this.self();
    }

    public T setLinePattern(String value) {
        this.linePattern.clear();
        this.linePattern.type(new CharSequence[]{value});
        return this.self();
    }

    @Nullable
    public String getLinePatternError() {
        return this.getFieldError(this.linePattern);
    }

    public T setPathPattern(String value) {
        this.pathPattern.clear();
        this.pathPattern.type(new CharSequence[]{value});
        return this.self();
    }

    @Nullable
    public String getPathPatternError() {
        return this.getFieldError(this.pathPattern);
    }

    public SecretScanningListPage save() {
        this.saveButton.click();
        SecretScanningListPage listPage = (SecretScanningListPage)this.pageBinder.bind(SecretScanningListPage.class, new Object[0]);
        Poller.waitUntilTrue((TimedQuery)listPage.isHereTimed());
        listPage.waitUntilLoaded();
        return listPage;
    }

    public T saveWithError() {
        this.saveButton.click();
        return this.self();
    }

    protected abstract T self();

    @Nullable
    private String getFieldError(PageElement field) {
        List errors = this.elementFinder.findAll(By.id((String)(field.getId() + "-error")));
        if (errors.isEmpty()) {
            return null;
        }
        if (errors.size() > 1) {
            throw new AssertionError((Object)"There should only be 1 error message for each field");
        }
        return ((PageElement)errors.get(0)).getText();
    }
}

