/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.search;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class SearchSettingsPage
extends BitbucketAdminPage {
    @ElementBy(name="awsRegion")
    private PageElement awsRegionInput;
    @ElementBy(name="AWS_REQUEST_SIGNING")
    private PageElement awsRegionRadio;
    @ElementBy(cssSelector="input[type='radio'][name='BASIC']")
    private PageElement basicAuthRadio;
    @ElementBy(cssSelector="[data-testid=\"search-configuration-disabled-information\"]")
    private PageElement disabledFieldsInfoMessage;
    @ElementBy(cssSelector="input[type='radio'][name='NONE']")
    private PageElement noneAuthRadio;
    @ElementBy(cssSelector="button[type='submit']")
    private PageElement saveButton;
    @ElementBy(cssSelector="[data-testid=\"search-configuration-lozenge\"]")
    private PageElement searchConnectionStatus;
    @ElementBy(cssSelector="[data-testid=\"error-message\"]")
    private PageElement searchConnectionErrorMessage;
    @ElementBy(name="password")
    private PageElement searchPasswordInput;
    @ElementBy(name="url")
    private PageElement searchBaseUrl;
    @ElementBy(name="username")
    private PageElement searchUsernameInput;
    @ElementBy(id="testConnectionButton")
    private PageElement testConnectionButton;
    @ElementBy(cssSelector="[data-testid=\"test-connection-message\"]")
    private PageElement testConnectionMessage;

    public String getUrl() {
        return "/plugins/servlet/search-server";
    }

    public PageElement clickTestConnectionButton() {
        this.testConnectionButton.click();
        Poller.waitUntilTrue((TimedQuery)this.testConnectionMessage.timed().isVisible());
        return this.testConnectionMessage;
    }

    public Flag clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isEnabled());
        this.saveButton.click();
        Flag successAlert = (Flag)((List)Poller.waitUntil(this.getAllFlags(), (Matcher)Matchers.not((Matcher)Matchers.empty()))).get(0);
        Poller.waitUntilTrue((TimedQuery)successAlert.isVisible());
        return successAlert;
    }

    private TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }

    public TimedQuery getConnectionstatus() {
        return this.searchConnectionStatus.timed().getText();
    }

    public String getDisabledInfoMessage() {
        Poller.waitUntilTrue((TimedQuery)this.disabledFieldsInfoMessage.timed().isVisible());
        return this.disabledFieldsInfoMessage.getText();
    }

    public PageElement getSaveButton() {
        return this.saveButton;
    }

    public SearchSettingsPage setSearchBaseUrl(String baseUrl) {
        this.searchBaseUrl.clear().type(new CharSequence[]{baseUrl});
        return this;
    }

    public SearchSettingsPage setAwsRegion(String awsRegion) {
        this.awsRegionRadio.select();
        Poller.waitUntilTrue((TimedQuery)this.awsRegionInput.timed().isVisible());
        this.awsRegionInput.clear().type(new CharSequence[]{awsRegion});
        return this;
    }

    public SearchSettingsPage setBasicAuth(String username, String password) {
        this.basicAuthRadio.select();
        Poller.waitUntilTrue((TimedQuery)this.searchUsernameInput.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.searchPasswordInput.timed().isVisible());
        this.searchUsernameInput.clear().type(new CharSequence[]{username});
        this.searchPasswordInput.clear().type(new CharSequence[]{password});
        return this;
    }

    public SearchSettingsPage setNoneAuthMethod() {
        this.noneAuthRadio.select();
        return this;
    }

    public boolean isFormDisabled() {
        return !this.noneAuthRadio.isEnabled() && !this.basicAuthRadio.isEnabled() && !this.awsRegionRadio.isEnabled();
    }
}

