/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.readme;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Supplier;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class Readme
extends LegacyElementPageObject {
    public Readme(@Nonnull PageElement element) {
        super(element);
    }

    public Readme(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    private PageElement getReadmeElement() {
        this.waitUntilVisible();
        final By by = By.className((String)"filebrowser-readme-content");
        Poller.waitUntilTrue((TimedQuery)Conditions.forSupplier((long)5000L, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !Readme.this.find(by).getText().isEmpty();
            }
        }));
        return this.find(by);
    }

    private void waitUntilVisible() {
        Poller.waitUntilTrue((TimedQuery)this.timed().isVisible());
    }

    public void waitUntilNotVisible() {
        Poller.waitUntilFalse((TimedQuery)this.timed().isVisible());
    }

    public String getReadmeTitle() {
        this.waitUntilVisible();
        return this.find(By.className((String)"filebrowser-readme-title")).getText();
    }

    public String getReadmeContent() {
        return this.getReadmeElement().getText();
    }

    public String getReadmeHtml() {
        return ElementUtils.getHtml(this.getReadmeElement());
    }
}

