/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.mirror;

import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorRequestDialog;
import com.atlassian.webdriver.bitbucket.page.mirror.MirrorNotificationPage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class ApprovalRequiredPage
extends MirrorNotificationPage {
    private static final Pattern URL_PATTERN = Pattern.compile("/(?<type>[^/]+)/(?<mirrorId>[^/]+)/authorize$");
    @ElementBy(id="goToPrimary")
    private PageElement goToPrimaryButton;
    @ElementBy(id="reregisterOnPrimary")
    private PageElement reRegisterOnPrimaryButton;

    @WaitUntil
    public void ensureCorrectPage() {
        PageElement pendingDiv = this.elementFinder.find(By.id((String)"mirrorPending"));
        try {
            Poller.waitUntilTrue((TimedQuery)pendingDiv.timed().isVisible());
        }
        catch (AssertionError e) {
            throw new PageBindingWaitException("Failed to find mirrorPending element on placeholder page", (Object)this);
        }
    }

    public MirrorRequestDialog clickGoToPrimary() {
        Matcher urlMatcher = this.getApprovalUrlMatcher();
        this.goToPrimaryButton.click();
        return (MirrorRequestDialog)this.pageBinder.bind(MirrorRequestDialog.class, new Object[]{urlMatcher.group("type"), urlMatcher.group("mirrorId")});
    }

    public MirrorRequestDialog clickReRegisterOnPrimary() {
        Matcher urlMatcher = this.getApprovalUrlMatcher();
        this.reRegisterOnPrimaryButton.click();
        return (MirrorRequestDialog)this.pageBinder.bind(MirrorRequestDialog.class, new Object[]{urlMatcher.group("type"), urlMatcher.group("mirrorId")});
    }

    private Matcher getApprovalUrlMatcher() {
        String approvalUrl = this.goToPrimaryButton.getAttribute("href");
        if (approvalUrl == null) {
            throw new IllegalStateException("Approval URL not found");
        }
        Matcher urlMatcher = URL_PATTERN.matcher(approvalUrl);
        if (!urlMatcher.find()) {
            throw new IllegalStateException("Approval URL '" + approvalUrl + "' does not match pattern " + String.valueOf(URL_PATTERN));
        }
        return urlMatcher;
    }
}

