/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.builds;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.builds.BuildResultRow;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public abstract class AbstractBuildsPage
extends BaseRepositoryPage {
    protected final String at;

    public AbstractBuildsPage(String projectKey, String repoSlug, String at) {
        super(projectKey, repoSlug);
        this.at = at;
    }

    public AbstractBuildsPage(String projectKey, String repoSlug) {
        this(projectKey, repoSlug, null);
    }

    public List<BuildResultRow> getRows() {
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"builds-list-spinner")).timed().isVisible());
        return this.elementFinder.findAll(By.className((String)"build-row")).stream().map(element -> new BuildResultRow(this.elementFinder, (PageElement)element)).collect(Collectors.toList());
    }

    public PageElement getBuildServerAuthorizationSuccessfulFlag() {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid=\"build-server-authorization-successful-notification\"]"));
    }

    public PageElement getActionSuccessfulFlag(String buildKey, String actionId) {
        return this.elementFinder.find(By.cssSelector((String)("[data-testid=\"build-action-success-" + actionId + "-" + buildKey + "\"]")));
    }
}

