/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.users;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.UserEditPage;
import org.openqa.selenium.By;

public class UserTableRow
extends AbstractElementPageObject {
    @ElementBy(cssSelector="[data-testid='confirm-action-modal']")
    private PageElement confirmDialog;
    @ElementBy(cssSelector="[data-testid='user-row-delete-action']")
    private PageElement deleteActionButton;
    @ElementBy(cssSelector="[data-testid='user-row-edit-action']")
    private PageElement editActionButton;
    private final PageElement userMeatballMenu;

    public UserTableRow(PageElement container) {
        super(container);
        this.userMeatballMenu = container.find(By.cssSelector((String)"[data-testid='user-row-more-actions-menu-button']"));
    }

    public void clickDelete() {
        this.userMeatballMenu.click();
        Poller.waitUntilTrue((TimedQuery)this.deleteActionButton.timed().isVisible());
        this.deleteActionButton.click();
        ConfirmDialog deleteDialog = (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.confirmDialog});
        deleteDialog.clickButton("Confirm");
    }

    public UserEditPage clickEdit() {
        this.userMeatballMenu.click();
        Poller.waitUntilTrue((TimedQuery)this.editActionButton.timed().isVisible());
        this.editActionButton.click();
        return (UserEditPage)this.pageBinder.bind(UserEditPage.class, new Object[0]);
    }

    public UserEditPage clickName() {
        PageElement nameLink = this.getColumn("name").find(By.tagName((String)"a"));
        Poller.waitUntilTrue((TimedQuery)nameLink.timed().isVisible());
        nameLink.click();
        return (UserEditPage)this.pageBinder.bind(UserEditPage.class, new Object[0]);
    }

    public PageElement getDeleteActionButton() {
        this.userMeatballMenu.click();
        Poller.waitUntilTrue((TimedQuery)this.deleteActionButton.timed().isVisible());
        return this.deleteActionButton;
    }

    public TimedQuery<String> getEmail() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getColumn("email").getText());
    }

    public TimedQuery<String> getName() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getColumn("name").getText());
    }

    public TimedQuery<String> getUsername() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getColumn("username").getText());
    }

    private PageElement getColumn(String section) {
        PageElement column = this.find(By.className((String)("col-" + section)));
        Poller.waitUntilTrue((TimedQuery)column.timed().isVisible());
        return column;
    }
}

