/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.reviewergroups;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class ReviewerGroupListItem
extends AbstractElementPageObject {
    private final PageElement actionsTrigger = this.find(By.className((String)"reviewer-group-actions"));
    private final PageElement groupName = this.find(By.className((String)"group-name"));
    private final PageElement inheritedLink = this.find(By.className((String)"project-settings-link"));
    @ElementBy(cssSelector="[data-testid='delete-reviewer-group-modal']")
    private PageElement deleteDialog;
    @Inject
    private PageElementFinder elementFinder;

    public ReviewerGroupListItem(@Nonnull PageElement container) {
        super(container);
        Poller.waitUntilTrue((TimedQuery)container.timed().isVisible());
    }

    public void clickEditGroup() {
        this.openActionsMenu();
        this.elementFinder.find(By.cssSelector((String)"[data-testid='edit-group']")).click();
    }

    public ConfirmDialog clickDeleteGroup() {
        this.openActionsMenu();
        PageElement deleteDropdownItem = this.elementFinder.find(By.cssSelector((String)"[data-testid='delete-group']"));
        deleteDropdownItem.click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteDialog});
    }

    public List<String> getGroupMembersName() {
        return (List)this.getGroupMembers().stream().map(element -> element.getAttribute("alt")).collect(MoreCollectors.toImmutableList());
    }

    public String getGroupName() {
        return this.groupName.getText();
    }

    public List<PageElement> getGroupMembers() {
        return this.container.findAll(By.cssSelector((String)".members img"));
    }

    public Boolean hasInheritedLink() {
        return this.inheritedLink.isVisible();
    }

    private ReviewerGroupListItem openActionsMenu() {
        this.actionsTrigger.click();
        PageElement deleteDropdownItem = this.elementFinder.find(By.cssSelector((String)"[data-testid='delete-group']"));
        Poller.waitUntilTrue((TimedQuery)deleteDropdownItem.timed().isVisible());
        return this;
    }
}

