/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.MoveConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.RepositoryManagementPage;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.ToggleArchiveConfirmationDialog;
import jakarta.inject.Inject;
import java.util.Objects;
import org.openqa.selenium.By;

public class RepositoryListItem
extends AbstractElementPageObject {
    private final RepositoryManagementPage page;
    @Inject
    private PageElementFinder elementFinder;

    public RepositoryListItem(PageElement container, RepositoryManagementPage page) {
        super(container);
        this.page = Objects.requireNonNull(page, "page");
    }

    public ToggleArchiveConfirmationDialog clickArchive() {
        PageElement archiveRepository = this.elementFinder.find(By.cssSelector((String)"[data-testid='archive-repository']"));
        Poller.waitUntilTrue((TimedQuery)archiveRepository.timed().isVisible());
        archiveRepository.click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='archive-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (ToggleArchiveConfirmationDialog)this.pageBinder.bind(ToggleArchiveConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public DeleteConfirmationDialog clickDelete() {
        PageElement deleteRepository = this.elementFinder.find(By.cssSelector((String)"[data-testid='delete-repository']"));
        Poller.waitUntilTrue((TimedQuery)deleteRepository.timed().isVisible());
        deleteRepository.click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='delete-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (DeleteConfirmationDialog)this.pageBinder.bind(DeleteConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public MoveConfirmationDialog clickMove() {
        PageElement moveRepository = this.elementFinder.find(By.cssSelector((String)"[data-testid='move-repository']"));
        Poller.waitUntilTrue((TimedQuery)moveRepository.timed().isVisible());
        moveRepository.click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='move-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (MoveConfirmationDialog)this.pageBinder.bind(MoveConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public void clickRelatedRepos() {
        PageElement relatedRepositories = this.elementFinder.find(By.cssSelector((String)"[data-testid='view-related-repositories']"));
        Poller.waitUntilTrue((TimedQuery)relatedRepositories.timed().isVisible());
        relatedRepositories.click();
    }

    public ToggleArchiveConfirmationDialog clickUnarchive() {
        PageElement unarchiveRepository = this.elementFinder.find(By.cssSelector((String)"[data-testid='unarchive-repository']"));
        Poller.waitUntilTrue((TimedQuery)unarchiveRepository.timed().isVisible());
        unarchiveRepository.click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='archive-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (ToggleArchiveConfirmationDialog)this.pageBinder.bind(ToggleArchiveConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public String getProjectName() {
        return this.container.find(By.className((String)"project-link")).getText();
    }

    public String getRepositoryDescription() {
        return this.container.find(By.className((String)"repo-description")).getText();
    }

    public String getRepositoryName() {
        return this.container.find(By.className((String)"repository-link")).getText();
    }

    public String getRepositorySize() {
        return this.container.find(By.className((String)"repository-size-col")).getText();
    }

    public boolean isArchived() {
        return this.container.findAll(By.className((String)"repo-lozenge")).size() > 0;
    }

    public boolean isSelected() {
        return this.container.find(By.cssSelector((String)"[data-testid=\"select-repository--hidden-checkbox\"]")).isSelected();
    }

    public RepositoryListItem openActionsMenu() {
        this.container.find(By.cssSelector((String)"button[data-testid='actions-menu-trigger']")).click();
        PageElement menuActions = this.elementFinder.find(By.className((String)"actions-menu-content"));
        Poller.waitUntilTrue((TimedQuery)menuActions.timed().isVisible());
        this.container.javascript().execute("window.scrollBy(0, 200)", new Object[0]);
        return this;
    }

    public void toggleSelect() {
        this.container.find(By.xpath((String)"td[1]")).click();
    }
}

