/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo.pushlog;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.openqa.selenium.By;

public class PushLogPage
extends BaseSidebarPage {
    private String projectKey;
    private String repositorySlug;

    public PushLogPage(String projectKey, String repositorySlug) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    public TimedQuery<List<PushLogRow>> getPushLogRows() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.elementFinder.findAll(By.className((String)"push-log-table-row")).stream().map(row -> (PushLogRow)this.pageBinder.bind(PushLogRow.class, new Object[]{row})).collect(MoreCollectors.toImmutableList()));
    }

    public TimedQuery<Integer> getPushLogRowsSize() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.elementFinder.findAll(By.className((String)"push-log-table-row")).size());
    }

    public PageElement getBranchSelectorDropdown() {
        return this.elementFinder.find(By.cssSelector((String)".filterable-tabs-selector.branch-selector"));
    }

    public TimedQuery<List<PageElement>> getBranchSelectorOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.elementFinder.findAll(By.cssSelector((String)"[data-testid=option]")).stream().collect(MoreCollectors.toImmutableList()));
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/push-log", this.projectKey.toUpperCase(), this.repositorySlug);
    }

    public static class PushLogRow
    extends AbstractElementPageObject {
        public PushLogRow(@Nonnull PageElement container) {
            super(container);
        }

        public String getFromHash() {
            return this.container.find(By.className((String)"push-event-from-hash")).getText();
        }

        public String getTimestamp() {
            return this.container.find(By.className((String)"activity-date")).getText();
        }

        public String getToHash() {
            return this.container.find(By.className((String)"push-event-to-hash")).getText();
        }

        public String getTrigger() {
            return this.container.find(By.className((String)"push-event-trigger")).getText();
        }

        public String getUsername() {
            return this.container.find(By.className((String)"user-name")).getText();
        }
    }
}

