/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.LocaleSelector;
import com.atlassian.webdriver.bitbucket.element.TimeZoneSelector;
import com.atlassian.webdriver.bitbucket.page.admin.AdminHomePage;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.admin.GitLfsAdminFormFragment;
import com.atlassian.webdriver.bitbucket.page.admin.SshAdminFormFragment;
import java.util.Collection;
import org.openqa.selenium.By;

public class ServerSettingsPage
extends BitbucketAdminPage {
    @ElementBy(className="stash-server-settings-form")
    private PageElement parentForm;
    @ElementBy(id="appTitle")
    private PageElement applicationTitle;
    @ElementBy(id="baseUrl")
    private PageElement baseUrl;
    @ElementBy(id="submit")
    private PageElement saveButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;
    @ElementBy(id="httpEnabled")
    private AuiCheckbox httpScmCheckbox;

    public ServerSettingsPage() {
    }

    public ServerSettingsPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/admin/server-settings";
    }

    public ServerSettingsPage setApplicationTitle(String applicationTitle) {
        this.applicationTitle.clear().type(new CharSequence[]{applicationTitle});
        return this;
    }

    public ServerSettingsPage setBaseUrl(String baseUrl) {
        this.baseUrl.clear().type(new CharSequence[]{baseUrl});
        return this;
    }

    public String getApplicationTitle() {
        return this.applicationTitle.getValue();
    }

    public String getBaseUrl() {
        return this.baseUrl.getValue();
    }

    public GitLfsAdminFormFragment getGitLfsFormFragment() {
        return (GitLfsAdminFormFragment)this.pageBinder.bind(GitLfsAdminFormFragment.class, new Object[]{this});
    }

    public LocaleSelector getLocale() {
        return new LocaleSelector(this.body);
    }

    public TimeZoneSelector getTimeZoneSelector() {
        return (TimeZoneSelector)this.pageBinder.bind(TimeZoneSelector.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_timezone"))});
    }

    public SshAdminFormFragment getSshFormFragment() {
        return (SshAdminFormFragment)this.pageBinder.bind(SshAdminFormFragment.class, new Object[]{this});
    }

    public ServerSettingsPage clickSave() {
        this.waitForPageLoad(() -> this.saveButton.click());
        return (ServerSettingsPage)this.pageBinder.bind(ServerSettingsPage.class, new Object[0]);
    }

    public AdminHomePage clickCancel() {
        this.cancelLink.click();
        return (AdminHomePage)this.pageBinder.bind(AdminHomePage.class, new Object[0]);
    }

    public ServerSettingsPage checkHttpScmCheckbox(boolean checked) {
        if (this.httpScmCheckbox.isSelected() != checked) {
            this.httpScmCheckbox.click();
        }
        return this;
    }

    public boolean isHttpScmEnabled() {
        return this.httpScmCheckbox.isSelected();
    }

    public Collection<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.parentForm);
    }
}

