/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.bitbucket.dmz.accessibility.ColorFilter;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AvatarPickerDialog;
import com.atlassian.webdriver.bitbucket.element.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.element.LocaleSelector;
import com.atlassian.webdriver.bitbucket.element.SimpleSelect;
import com.atlassian.webdriver.bitbucket.element.TimeZoneSelector;
import com.atlassian.webdriver.bitbucket.element.UserAvatarDeleteDialog;
import com.atlassian.webdriver.bitbucket.element.UserAvatarPickerDialog;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.UserAccountEmailPage;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class UserAccountSettingsPage
extends BitbucketPage {
    private String colorFilterAttr = "data-color-accessibility-mode";
    @ElementBy(id="displayName")
    private PageElement displayNameField;
    @ElementBy(id="emailAddress")
    private PageElement emailAddress;
    @ElementBy(id="submit")
    private PageElement submitButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;
    @ElementBy(className="account-settings")
    private PageElement accountSettingsSection;
    @ElementBy(className="aui-navgroup-vertical")
    private PageElement sidebarSection;
    @ElementBy(cssSelector=".user-avatar-form .avatar-delete-trigger")
    private PageElement avatarDeleteButton;
    @ElementBy(cssSelector=".user-avatar-form .avatar-picker-trigger")
    private PageElement avatarPickerButton;
    @ElementBy(cssSelector=".user-avatar-form .user-avatar")
    private PageElement avatar;
    @ElementBy(id="is-relative-radio")
    private AuiCheckbox relativeDateRadioButton;
    @ElementBy(id="is-absolute-radio")
    private AuiCheckbox absoluteDateRadioButton;
    @ElementBy(id="s2id_colorFilter")
    private PageElement colorFilterSelect;
    @ElementBy(cssSelector="#select2-drop.select2-drop-active")
    private PageElement colorFilterSelectMenu;
    @ElementBy(cssSelector="html")
    private PageElement rootElement;

    public String getUrl() {
        return "/account";
    }

    public void setDisplayName(String name) {
        this.displayNameField.clear().type(new CharSequence[]{name});
    }

    public String getDisplayName() {
        return this.displayNameField.getValue();
    }

    public List<PageElement> getSidebarLinks() {
        return this.elementFinder.findAll(By.cssSelector((String)".aui-page-panel-nav li"));
    }

    public void setEmailAddress(String address) {
        this.emailAddress.clear().type(new CharSequence[]{address});
    }

    public LocaleSelector getLocale() {
        return new LocaleSelector(this.body);
    }

    public TimeZoneSelector getTimeZoneSelector() {
        return (TimeZoneSelector)this.pageBinder.bind(TimeZoneSelector.class, new Object[]{this.elementFinder.find(By.id((String)"s2id_timezone"))});
    }

    public SimpleSelect getColorFilterSelector() {
        return (SimpleSelect)this.pageBinder.bind(SimpleSelect.class, new Object[]{this.colorFilterSelect, this.colorFilterSelectMenu});
    }

    public String getDatePreference() {
        return this.elementFinder.find(By.cssSelector((String)"#dateFormatPreferenceField input[type=\"radio\"]:checked")).getValue();
    }

    public ColorFilter getActiveColorFilter() {
        String activeColorFilter = this.rootElement.getAttribute(this.colorFilterAttr);
        if (activeColorFilter == null) {
            return ColorFilter.NONE;
        }
        if (activeColorFilter.equals("tritanopia")) {
            return ColorFilter.BLUE_YELLOW;
        }
        if (activeColorFilter.equals("protanopia")) {
            return ColorFilter.RED_GREEN;
        }
        if (activeColorFilter.equals("full")) {
            return ColorFilter.GREYSCALE;
        }
        return null;
    }

    public ColorFilter getFormSelectedColorFilter() {
        String colorFilterSelection = this.getColorFilterSelector().getSelection();
        if (colorFilterSelection.contains("Tritanopia")) {
            return ColorFilter.BLUE_YELLOW;
        }
        if (colorFilterSelection.contains("Protanopia")) {
            return ColorFilter.RED_GREEN;
        }
        if (colorFilterSelection.contains("Full")) {
            return ColorFilter.GREYSCALE;
        }
        return ColorFilter.NONE;
    }

    public void setDatePreference(String preference) {
        if (preference == "ABSOLUTE") {
            this.absoluteDateRadioButton.select();
        } else {
            this.relativeDateRadioButton.select();
        }
    }

    public String getEmailAddress() {
        return this.emailAddress.getValue();
    }

    public boolean isEmailAddressInputDisabled() {
        return !this.elementFinder.find(By.id((String)"emailAddressDisabled")).isEnabled();
    }

    public UserAccountEmailPage clickChangeEmailLink() {
        this.accountSettingsSection.find(By.linkText((String)"change email")).click();
        return (UserAccountEmailPage)this.pageBinder.bind(UserAccountEmailPage.class, new Object[0]);
    }

    public boolean hasChangeEmailLink() {
        return this.accountSettingsSection.find(By.linkText((String)"change email")).isPresent();
    }

    public UserAccountEmailPage clickSidebarChangeEmailTab() {
        this.sidebarSection.find(By.linkText((String)"Change email")).click();
        return (UserAccountEmailPage)this.pageBinder.bind(UserAccountEmailPage.class, new Object[0]);
    }

    public boolean hasSidebarChangeEmailTab() {
        return this.sidebarSection.find(By.linkText((String)"Change email")).isPresent();
    }

    public UserAccountSettingsPage submit() {
        this.submitButton.click();
        return (UserAccountSettingsPage)this.pageBinder.bind(UserAccountSettingsPage.class, new Object[0]);
    }

    public String getAvatarUrl() {
        return this.avatar.find(By.tagName((String)"img")).getAttribute("src");
    }

    public boolean canDeleteAvatar() {
        this.elementFinder.find(By.className((String)"avatar-delete-overlay")).javascript().execute("jQuery(arguments[0]).css('opacity', '1')", new Object[0]);
        return this.avatarDeleteButton.isVisible();
    }

    public DeleteConfirmationDialog<UserAccountSettingsPage> clickDeleteAvatar() {
        this.avatarDeleteButton.click();
        return (DeleteConfirmationDialog)((Object)this.pageBinder.bind(UserAvatarDeleteDialog.class, new Object[]{this}));
    }

    public List<String> getAvatarUrlsFor(String user) {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.elementFinder.findAll(By.cssSelector((String)String.format(".aui-avatar[data-username=%s] .aui-avatar-inner > img", user))), avatar -> avatar.getAttribute("src")));
    }

    public boolean hasGravatarNotice() {
        return this.elementFinder.find(By.className((String)"gravatar-notice")).isVisible();
    }

    public AvatarPickerDialog<UserAccountSettingsPage> openAvatarDialog() {
        this.avatarPickerButton.click();
        return (AvatarPickerDialog)((Object)this.pageBinder.bind(UserAvatarPickerDialog.class, new Object[]{this}));
    }

    public UserAccountSettingsPage waitAvatarIsUpdated() {
        Poller.waitUntilFalse((TimedQuery)this.avatar.find(By.className((String)"spinner")).timed().isPresent());
        return (UserAccountSettingsPage)this.pageBinder.bind(UserAccountSettingsPage.class, new Object[0]);
    }
}

