/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;

public class UserAccountEmailPage
extends BitbucketPage {
    @ElementBy(id="currentPassword")
    private PageElement currentPassword;
    @ElementBy(id="currentPassword-error-message-0")
    private PageElement currentPasswordError;
    @ElementBy(id="emailAddress")
    private PageElement emailAddress;
    @ElementBy(id="emailAddress-error-message-0")
    private PageElement emailAddressError;
    @ElementBy(id="submit")
    private PageElement submitButton;
    @ElementBy(cssSelector=".aui-message.aui-message-success.success")
    private PageElement successMessage;

    public String getEmailAddress() {
        return this.emailAddress.getValue();
    }

    public String getEmailAddressError() {
        Poller.waitUntilTrue((TimedQuery)this.emailAddressError.timed().isPresent());
        return this.emailAddressError.getText();
    }

    public String getPasswordError() {
        Poller.waitUntilTrue((TimedQuery)this.currentPasswordError.timed().isPresent());
        return this.currentPasswordError.getText();
    }

    public String getUrl() {
        return "/account/email";
    }

    public String getSuccessMessageText() {
        return this.successMessage.getText();
    }

    public void setCurrentPassword(String password) {
        this.currentPassword.clear().type(new CharSequence[]{password});
    }

    public void setEmailAddress(String password) {
        this.emailAddress.clear().type(new CharSequence[]{password});
    }

    public UserAccountEmailPage submit() {
        this.submitButton.click();
        return (UserAccountEmailPage)this.pageBinder.bind(UserAccountEmailPage.class, new Object[0]);
    }
}

