/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.GitLfsRepositorySettingsFormFragment;
import com.atlassian.webdriver.bitbucket.page.PullRequestListPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryArchiveConfirmationPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryDeleteConfirmationPage;
import com.atlassian.webdriver.bitbucket.page.TranscodeDiffFormFragment;
import com.atlassian.webdriver.bitbucket.page.admin.repo.AuditRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.admin.repo.pushlog.PushLogPage;
import java.util.List;
import org.openqa.selenium.By;

public class RepositoryEditSettingsPage
extends BaseRepositoryPage {
    @ElementBy(id="repository-settings-archive-button")
    private PageElement archiveButton;
    @ElementBy(id="repository-archived-banner")
    private PageElement archivedBanner;
    @ElementBy(id="audit-web-item-link-bitbucket")
    private PageElement auditLogMenuItem;
    @ElementBy(id="banner-archive-repository-link")
    private PageElement bannerUnarchiveButton;
    @ElementBy(id="repository-settings-delete-button")
    private PageElement deleteButton;
    @ElementBy(name="forkable")
    private AuiCheckbox forkableCheckbox;
    @ElementBy(className="stash-repository-edit-settings-form")
    private PageElement form;
    @ElementBy(className="manage-repo-menu-trigger")
    private PageElement manageRepoMenu;
    @ElementBy(id="repository-settings-move-button")
    private PageElement moveButton;
    @ElementBy(name="name")
    private PageElement nameField;
    @ElementBy(cssSelector="li > a[title='View Push Log']")
    private PageElement pushLogMenuItem;
    @ElementBy(className="aui-page-panel-nav")
    private PageElement settingsTabsNavPanel;
    @ElementBy(id="size")
    private PageElement sizeElement;
    @ElementBy(name="submit")
    private PageElement submitButton;

    public RepositoryEditSettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public RepositoryArchiveConfirmationPage clickArchive() {
        this.archiveButton.click();
        return (RepositoryArchiveConfirmationPage)this.pageBinder.bind(RepositoryArchiveConfirmationPage.class, new Object[]{this.projectKey, this.slug});
    }

    public PullRequestListPage clickAuiErrorFlagLink() {
        this.getAuiFlagErrorMessagesLink().click();
        return (PullRequestListPage)this.pageBinder.bind(PullRequestListPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryArchiveConfirmationPage clickBannerUnarchiveButton() {
        this.bannerUnarchiveButton.click();
        return (RepositoryArchiveConfirmationPage)this.pageBinder.bind(RepositoryArchiveConfirmationPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryDeleteConfirmationPage clickDelete() {
        this.manageRepoMenu.click();
        this.deleteButton.click();
        return (RepositoryDeleteConfirmationPage)this.pageBinder.bind(RepositoryDeleteConfirmationPage.class, new Object[]{this.projectKey, this.slug});
    }

    public String getAuiSuccessFlagMessage() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-flag")).timed().isVisible());
        return this.body.find(By.className((String)"aui-message-success")).getText();
    }

    public GitLfsRepositorySettingsFormFragment getGitLfsRepositorySettingsFormFragment() {
        return (GitLfsRepositorySettingsFormFragment)this.pageBinder.bind(GitLfsRepositorySettingsFormFragment.class, new Object[]{this});
    }

    public TranscodeDiffFormFragment getTranscodeDiffFormFragment() {
        return (TranscodeDiffFormFragment)this.pageBinder.bind(TranscodeDiffFormFragment.class, new Object[]{this});
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings", this.projectKey, this.slug);
    }

    public String retrieveSizeDetails() {
        this.sizeElement.find(By.tagName((String)"button")).click();
        Poller.waitUntilFalse((TimedQuery)this.sizeElement.find(By.tagName((String)"button")).withTimeout(TimeoutType.AJAX_ACTION).timed().isVisible());
        return this.sizeElement.getText();
    }

    public RepositoryEditSettingsPage setName(String name) {
        this.nameField.clear();
        this.nameField.type(new CharSequence[]{name});
        return this;
    }

    public RepositoryEditSettingsPage setForkable(boolean forkable) {
        if (this.forkableCheckbox.isSelected() != forkable) {
            this.forkableCheckbox.click();
        }
        return this;
    }

    public String getNameValue() {
        return this.nameField.getValue();
    }

    public boolean isArchivedBannerVisible() {
        return this.archivedBanner.isVisible();
    }

    public boolean isDeleteShowing() {
        return this.deleteButton.isPresent();
    }

    public boolean isMoveDisabled() {
        return this.moveButton.hasAttribute("disabled", "true");
    }

    public boolean isSubmitEnabled() {
        return this.submitButton.isEnabled();
    }

    public RepositoryEditSettingsPage openActionsMenu() {
        this.manageRepoMenu.click();
        return this;
    }

    public AuditRepositoryPage openAuditLog(int repositoryId) {
        this.auditLogMenuItem.click();
        return (AuditRepositoryPage)this.pageBinder.bind(AuditRepositoryPage.class, new Object[]{this.projectKey, repositoryId, this.slug, this.getProjectName(), this.getRepositoryName()});
    }

    public PushLogPage openPushLog() {
        this.pushLogMenuItem.click();
        return (PushLogPage)this.pageBinder.bind(PushLogPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage submitSuccess() {
        String slug = this.nameField.getValue();
        this.waitForPageLoad(() -> this.submitButton.click());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, slug});
    }

    public RepositoryEditSettingsPage submitFail() {
        this.submitButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#submit:enabled")).timed().isPresent());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.form);
    }

    public boolean isNameFieldWithError() {
        return this.getFieldsWithErrors().contains("name");
    }

    public <P extends BaseSidebarPage> P getSettingsTabPage(Class<P> page, String tabTitle, Object ... args) {
        Poller.waitUntilTrue((TimedQuery)this.settingsTabsNavPanel.timed().isPresent());
        PageElement settingsTab = this.settingsTabsNavPanel.find(By.linkText((String)tabTitle));
        Poller.waitUntilTrue((TimedQuery)settingsTab.timed().isVisible());
        settingsTab.click();
        return (P)((BaseSidebarPage)this.pageBinder.bind(page, args));
    }
}

