/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseMergeStrategiesSettingsPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class ProjectMergeStrategiesSettingsPage
extends BaseMergeStrategiesSettingsPage {
    private final String projectKey;
    private final String scm;

    public ProjectMergeStrategiesSettingsPage(String projectKey, String scm) {
        this.projectKey = projectKey;
        this.scm = scm;
    }

    public void clickSaveWithNewRestriction() {
        this.scrollToBottom();
        this.saveButton.click();
        PageElement confirmRestrictChangesButton = this.elementFinder.find(By.cssSelector((String)"[data-testid='cancel-confirmation-modal-confirm-button']"));
        Poller.waitUntilTrue((TimedQuery)confirmRestrictChangesButton.timed().isVisible());
        confirmRestrictChangesButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"[data-testid=\"save-success-flag\"]")).timed().isVisible());
    }

    public String getUrl() {
        return String.format("/projects/%s/settings/merge-strategies/%s", this.projectKey, this.scm);
    }

    public TimedQuery<Boolean> isNotRestricted() {
        return this.verifyRestrictionState("UNLOCKED");
    }

    public TimedQuery<Boolean> isRestricted() {
        return this.elementFinder.find(By.cssSelector((String)"span .locked-icon")).timed().isPresent();
    }

    public TimedQuery<Boolean> isRestrictionDropdownEnabled() {
        return this.elementFinder.find(By.id((String)"enforce-settings-dropdown")).timed().isEnabled();
    }

    public TimedQuery<Boolean> isRestrictionProcessing() {
        return this.elementFinder.find(By.cssSelector((String)"[data-testid='restriction-processing']")).timed().isPresent();
    }

    public void setRestriction(boolean isRestricted) {
        this.elementFinder.find(By.id((String)"enforce-settings-dropdown")).click();
        Poller.waitUntil(this.getDropdownOptions(), (Matcher)Matchers.iterableWithSize((int)2));
        List dropDownOptions = (List)this.getDropdownOptions().now();
        if (isRestricted) {
            ((PageElement)dropDownOptions.get(0)).click();
        } else {
            ((PageElement)dropDownOptions.get(1)).click();
        }
    }

    private TimedQuery<List<PageElement>> getDropdownOptions() {
        List menuItems = this.elementFinder.findAll(By.cssSelector((String)"button[role=\"menuitem\"]"));
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)menuItems.stream().collect(MoreCollectors.toImmutableList()));
    }

    private TimedQuery<Boolean> verifyRestrictionState(String restrictionState) {
        return this.elementFinder.find(By.cssSelector((String)("button > p[data-value=\"" + restrictionState + "\"]"))).timed().isPresent();
    }
}

