/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class CodeInsightsSettingsPage
extends BaseSidebarPage {
    private final String projectKey;
    private final String repoSlug;

    public CodeInsightsSettingsPage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public CodeInsightsSettingsPage(String projectKey) {
        this.projectKey = projectKey;
        this.repoSlug = null;
    }

    public CodeInsightsSettingsPage add(boolean successful) {
        final String reportKey = this.elementFinder.find(By.id((String)"input-report-key")).getValue();
        final int initialSize = this.getSettings().size();
        this.elementFinder.find(By.cssSelector((String)".actions button")).click();
        if (successful) {
            Poller.waitUntilTrue((TimedQuery)new AbstractTimedCondition(5000L, 50L){

                protected Boolean currentValue() {
                    return CodeInsightsSettingsPage.this.getSettings().size() > initialSize && reportKey.equals(CodeInsightsSettingsPage.this.getSettings().get(0).getReportKey());
                }
            });
        }
        return this;
    }

    public List<CodeInsightsSettingsRow> getSettings() {
        List rows = this.elementFinder.findAll(By.cssSelector((String)".code-insights-merge-check-settings tbody tr"));
        if (rows.size() < 2) {
            return Collections.emptyList();
        }
        return rows.subList(1, rows.size()).stream().map(row -> new CodeInsightsSettingsRow((PageElement)row, this)).collect(Collectors.toList());
    }

    public String getUrl() {
        return "/plugins/servlet/insights/projects/" + this.projectKey + (String)(this.repoSlug == null ? "" : "/repos/" + this.repoSlug);
    }

    public CodeInsightsSettingsPage selectMinSeverity(String minSeverity) {
        this.elementFinder.find(By.cssSelector((String)("#input-min-disallowed-sevs option[value='" + minSeverity + "']"))).select();
        return this;
    }

    public CodeInsightsSettingsPage setMustPass(boolean mustPass) {
        this.elementFinder.find(By.cssSelector((String)("#input-requires-non-failing option[value='" + mustPass + "']"))).select();
        return this;
    }

    public CodeInsightsSettingsPage typeReportKey(String reportKey) {
        PageElement input = this.elementFinder.find(By.id((String)"input-report-key"));
        input.type(new CharSequence[]{reportKey});
        Poller.waitUntil((TimedQuery)input.timed().getValue(), (Matcher)Matchers.equalToIgnoringCase((String)reportKey));
        return this;
    }

    public static class CodeInsightsSettingsRow
    extends AbstractElementPageObject {
        private final CodeInsightsSettingsPage parent;

        protected CodeInsightsSettingsRow(@Nonnull PageElement container, CodeInsightsSettingsPage parent) {
            super(container);
            this.parent = parent;
        }

        public boolean canDelete() {
            return this.container.find(By.tagName((String)"button")).isVisible();
        }

        public CodeInsightsSettingsPage delete() {
            this.container.find(By.tagName((String)"button")).click();
            Poller.waitUntilFalse((TimedQuery)this.container.find(By.tagName((String)"td")).timed().isPresent());
            return this.parent;
        }

        public String getMinProhibitedSeverity() {
            return this.container.find(By.cssSelector((String)"td[headers=min-disallowed-sevs]")).getText();
        }

        public String getReportKey() {
            return this.container.find(By.cssSelector((String)"td[headers=report-key]")).getText();
        }

        public boolean isMustPass() {
            return "MUST PASS".equals(this.container.find(By.cssSelector((String)"td[headers=requires-non-failing]")).getText());
        }
    }
}

