/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.dashboard;

import com.atlassian.bitbucket.pageobjects.page.next.PullRequestCreatePage;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class DashboardPullRequestSuggestions
extends AbstractElementPageObject {
    public DashboardPullRequestSuggestions(@Nonnull PageElement container) {
        super(container);
    }

    public List<PullRequestSuggestionRow> getSuggestedPullRequests() {
        return this.container.findAll(By.tagName((String)"li")).stream().map(ElementUtils.bind(this.pageBinder, PullRequestSuggestionRow.class, new Object[0])).collect(Collectors.toList());
    }

    public TimedQuery<Boolean> isVisible() {
        return this.container.timed().isVisible();
    }

    public static class PullRequestSuggestionRow
    extends AbstractElementPageObject {
        private final PageElement createButton;

        public PullRequestSuggestionRow(@Nonnull PageElement container) {
            super(container);
            this.createButton = container.find(By.className((String)"create-button"));
        }

        public PullRequestCreatePage clickCreatePullRequest(String projectKey, String repoSlug) {
            this.createButton.timed().isPresent();
            this.createButton.click();
            return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{projectKey, repoSlug});
        }

        public BuildStatusIcon getBuildStatus() {
            PageElement icon = this.container.find(By.cssSelector((String)"[data-testid=\"build-summary-icon-link\"]"));
            return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
        }

        public String getPushedToBranch() {
            return (String)this.container.find(By.cssSelector((String)".suggestion-text a")).timed().getText().byDefaultTimeout();
        }
    }
}

